/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.GsonJsonArray;
import com.github.wnameless.json.base.GsonJsonObject;
import com.github.wnameless.json.base.JsonValueBase;
import com.github.wnameless.json.base.Jsonable;
import com.google.gson.JsonElement;
import java.util.Objects;

public final class GsonJsonValue
implements JsonValueBase<GsonJsonValue>,
Jsonable {
    private final JsonElement jsonValue;

    public GsonJsonValue(JsonElement jsonValue) {
        this.jsonValue = jsonValue;
    }

    @Override
    public boolean isObject() {
        return this.jsonValue.isJsonObject();
    }

    @Override
    public boolean isArray() {
        return this.jsonValue.isJsonArray();
    }

    @Override
    public boolean isNumber() {
        return this.jsonValue.isJsonPrimitive() ? this.jsonValue.getAsJsonPrimitive().isNumber() : false;
    }

    @Override
    public boolean isString() {
        return this.jsonValue.isJsonPrimitive() ? this.jsonValue.getAsJsonPrimitive().isString() : false;
    }

    @Override
    public boolean isBoolean() {
        return this.jsonValue.isJsonPrimitive() ? this.jsonValue.getAsJsonPrimitive().isBoolean() : false;
    }

    @Override
    public boolean isNull() {
        return this.jsonValue.isJsonNull();
    }

    public GsonJsonObject asObject() {
        return new GsonJsonObject(this.jsonValue.getAsJsonObject());
    }

    public GsonJsonArray asArray() {
        return new GsonJsonArray(this.jsonValue.getAsJsonArray());
    }

    @Override
    public int asInt() {
        return this.jsonValue.getAsInt();
    }

    @Override
    public long asLong() {
        return this.jsonValue.getAsLong();
    }

    @Override
    public double asDouble() {
        return this.jsonValue.getAsDouble();
    }

    @Override
    public String asString() {
        return this.jsonValue.getAsString();
    }

    @Override
    public boolean asBoolean() {
        return this.jsonValue.getAsBoolean();
    }

    public int hashCode() {
        return this.jsonValue.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GsonJsonValue)) {
            return false;
        }
        return Objects.equals(this.jsonValue, ((GsonJsonValue)o).jsonValue);
    }

    public String toString() {
        return this.jsonValue.toString();
    }

    @Override
    public String toJson() {
        return this.toString();
    }
}

