/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.github.wnameless.json.flattener.IndexedPeekIterator;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;

public final class JsonFlattener {
    private static final CharSequenceTranslator ESCAPE_JSON_WITHOUT_UNICODE = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}, {"/", "\\/"}}), new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())});
    private final JsonValue source;
    private final Deque<IndexedPeekIterator<?>> elementIters = new ArrayDeque();
    private final Map<String, Object> flattenedJsonMap = new LinkedHashMap<String, Object>();
    private String flattenedJson = null;

    public static String flatten(String json) {
        return new JsonFlattener(json).flatten();
    }

    public static Map<String, Object> flattenAsMap(String json) {
        return new JsonFlattener(json).flattenAsMap();
    }

    public JsonFlattener(String json) {
        this.source = Json.parse((String)json);
        if (!this.source.isObject() && !this.source.isArray()) {
            throw new IllegalArgumentException("Input must be a JSON object or array");
        }
        if (this.source.isObject() && !this.source.asObject().iterator().hasNext()) {
            this.flattenedJson = "{}";
            return;
        }
        if (this.source.isArray() && !this.source.asArray().iterator().hasNext()) {
            this.flattenedJson = "[]";
            return;
        }
        this.reduce(this.source);
    }

    public String flatten() {
        if (this.flattenedJson != null) {
            return this.flattenedJson;
        }
        this.flattenAsMap();
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<String, Object> mem : this.flattenedJsonMap.entrySet()) {
            String key = mem.getKey();
            Object val = mem.getValue();
            sb.append("\"");
            sb.append(key);
            sb.append("\"");
            sb.append(":");
            if (val instanceof Boolean) {
                sb.append(val);
            } else if (val instanceof String) {
                sb.append("\"");
                sb.append(ESCAPE_JSON_WITHOUT_UNICODE.translate((CharSequence)((String)val)));
                sb.append("\"");
            } else if (val instanceof BigDecimal) {
                sb.append(val);
            } else if (val instanceof List) {
                sb.append("[]");
            } else if (val instanceof Map) {
                sb.append("{}");
            } else {
                sb.append("null");
            }
            sb.append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        this.flattenedJson = sb.toString();
        return this.flattenedJson;
    }

    public Map<String, Object> flattenAsMap() {
        while (!this.elementIters.isEmpty()) {
            IndexedPeekIterator<?> deepestIter = this.elementIters.getLast();
            if (!deepestIter.hasNext()) {
                this.elementIters.removeLast();
                continue;
            }
            if (deepestIter.peek() instanceof JsonObject.Member) {
                JsonObject.Member mem = (JsonObject.Member)deepestIter.next();
                this.reduce(mem.getValue());
                continue;
            }
            JsonValue val = (JsonValue)deepestIter.next();
            this.reduce(val);
        }
        return this.flattenedJsonMap;
    }

    private void reduce(JsonValue val) {
        if (val.isObject() && val.asObject().iterator().hasNext()) {
            this.elementIters.add(new IndexedPeekIterator(val.asObject().iterator()));
        } else if (val.isArray() && val.asArray().iterator().hasNext()) {
            this.elementIters.add(new IndexedPeekIterator(val.asArray().iterator()));
        } else {
            this.flattenedJsonMap.put(this.computeKey(), this.jsonVal2Obj(val));
        }
    }

    private Object jsonVal2Obj(JsonValue jsonValue) {
        if (jsonValue.isBoolean()) {
            return jsonValue.asBoolean();
        }
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        if (jsonValue.isNumber()) {
            return new BigDecimal(jsonValue.toString());
        }
        if (jsonValue.isArray()) {
            return new ArrayList();
        }
        if (jsonValue.isObject()) {
            return new LinkedHashMap();
        }
        return null;
    }

    private String computeKey() {
        StringBuilder sb = new StringBuilder();
        for (IndexedPeekIterator<?> iter : this.elementIters) {
            if (iter.getCurrent() instanceof JsonObject.Member) {
                String key = ((JsonObject.Member)iter.getCurrent()).getName();
                if (key.contains(".")) {
                    sb.append('[');
                    sb.append('\\');
                    sb.append('\"');
                    sb.append(ESCAPE_JSON_WITHOUT_UNICODE.translate((CharSequence)key));
                    sb.append('\\');
                    sb.append('\"');
                    sb.append(']');
                    continue;
                }
                if (sb.length() != 0) {
                    sb.append('.');
                }
                sb.append(ESCAPE_JSON_WITHOUT_UNICODE.translate((CharSequence)key));
                continue;
            }
            sb.append('[');
            sb.append(iter.getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.source.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonFlattener)) {
            return false;
        }
        return this.source.equals((Object)((JsonFlattener)o).source);
    }

    public String toString() {
        return "JsonFlattener{source=" + this.source + "}";
    }
}

