/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;

public class AHBottomNavigationItem {
    private String title = "";
    private Drawable icon;
    private Drawable selectedIcon;
    private String tag;
    private int color = -7829368;
    @DrawableRes
    private int iconRes = 0;
    @DrawableRes
    private int selectedIconRes = 0;
    @StringRes
    private int titleRes = 0;
    @ColorRes
    private int colorRes = 0;

    public AHBottomNavigationItem(String title, @DrawableRes int iconRes) {
        this.title = title;
        this.iconRes = iconRes;
    }

    @Deprecated
    public AHBottomNavigationItem(String title, @DrawableRes int iconRes, @ColorRes int color2) {
        this.title = title;
        this.iconRes = iconRes;
        this.color = color2;
    }

    public AHBottomNavigationItem(@StringRes int titleRes, @DrawableRes int iconRes, @ColorRes int colorRes) {
        this.titleRes = titleRes;
        this.iconRes = iconRes;
        this.colorRes = colorRes;
    }

    public AHBottomNavigationItem(@StringRes int titleRes, @DrawableRes int iconRes) {
        this.titleRes = titleRes;
        this.iconRes = iconRes;
    }

    public AHBottomNavigationItem(String title, Drawable drawable2) {
        this.title = title;
        this.icon = drawable2;
    }

    public AHBottomNavigationItem(String title, Drawable icon, Drawable selectedIcon, String tag) {
        this.title = title;
        this.icon = icon;
        this.tag = tag;
    }

    public AHBottomNavigationItem(String title, Drawable drawable2, @ColorInt int color2) {
        this.title = title;
        this.icon = drawable2;
        this.color = color2;
    }

    public String getTitle(Context context) {
        if (this.titleRes != 0) {
            return context.getString(this.titleRes);
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleRes = 0;
    }

    public void setTitle(@StringRes int titleRes) {
        this.titleRes = titleRes;
        this.title = "";
    }

    public int getColor(Context context) {
        if (this.colorRes != 0) {
            return ContextCompat.getColor((Context)context, (int)this.colorRes);
        }
        return this.color;
    }

    public void setColor(@ColorInt int color2) {
        this.color = color2;
        this.colorRes = 0;
    }

    public void setColorRes(@ColorRes int colorRes) {
        this.colorRes = colorRes;
        this.color = 0;
    }

    public Drawable getDrawable(Context context) {
        Drawable icon = this.icon == null ? this.getResourceDrawable(context, this.iconRes) : this.icon;
        Drawable selectedIcon = this.selectedIcon == null ? this.getResourceDrawable(context, this.selectedIconRes) : this.selectedIcon;
        StateListDrawable stateDrawable = new StateListDrawable();
        if (selectedIcon != null) {
            stateDrawable.addState(new int[]{0x10100A1}, selectedIcon);
        }
        stateDrawable.addState(new int[0], icon);
        return stateDrawable;
    }

    public void setIcon(@DrawableRes int drawableRes) {
        this.iconRes = drawableRes;
        this.icon = null;
    }

    public void setIcon(Drawable drawable2) {
        this.icon = drawable2;
        this.iconRes = 0;
    }

    public void setSelectedIcon(Drawable selectedIcon) {
        this.selectedIcon = selectedIcon;
    }

    public void setSelectedIcon(@DrawableRes int selectedIconRes) {
        this.selectedIconRes = selectedIconRes;
    }

    public String getTag() {
        return this.tag;
    }

    private Drawable getResourceDrawable(Context context, @DrawableRes int drawableRes) {
        if (drawableRes != 0) {
            try {
                return AppCompatResources.getDrawable((Context)context, (int)drawableRes);
            }
            catch (Resources.NotFoundException e) {
                return ContextCompat.getDrawable((Context)context, (int)drawableRes);
            }
        }
        return null;
    }
}

