/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TabLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigation;
import com.aurelhubert.ahbottomnavigation.R;
import com.aurelhubert.ahbottomnavigation.VerticalScrollingBehavior;

public class AHBottomNavigationBehavior<V extends View>
extends VerticalScrollingBehavior<V> {
    private static final Interpolator INTERPOLATOR = new LinearOutSlowInInterpolator();
    private static final int ANIM_DURATION = 300;
    private int mTabLayoutId;
    private boolean hidden = false;
    private ViewPropertyAnimatorCompat translationAnimator;
    private ObjectAnimator translationObjectAnimator;
    private TabLayout mTabLayout;
    private Snackbar.SnackbarLayout snackbarLayout;
    private FloatingActionButton floatingActionButton;
    private int mSnackbarHeight = -1;
    private int navigationBarHeight = 0;
    private boolean fabBottomMarginInitialized = false;
    private float targetOffset = 0.0f;
    private float fabTargetOffset = 0.0f;
    private float fabDefaultBottomMargin = 0.0f;
    private float snackBarY = 0.0f;
    private boolean behaviorTranslationEnabled = true;
    private AHBottomNavigation.OnNavigationPositionListener navigationPositionListener;

    public AHBottomNavigationBehavior() {
    }

    public AHBottomNavigationBehavior(boolean behaviorTranslationEnabled, int navigationBarHeight) {
        this.behaviorTranslationEnabled = behaviorTranslationEnabled;
        this.navigationBarHeight = navigationBarHeight;
    }

    public AHBottomNavigationBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AHBottomNavigationBehavior_Params);
        this.mTabLayoutId = a.getResourceId(R.styleable.AHBottomNavigationBehavior_Params_tabLayoutId, -1);
        a.recycle();
    }

    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        boolean layoutChild = super.onLayoutChild(parent, child, layoutDirection);
        if (this.mTabLayout == null && this.mTabLayoutId != -1) {
            this.mTabLayout = this.findTabLayout((View)child);
        }
        return layoutChild;
    }

    private TabLayout findTabLayout(View child) {
        if (this.mTabLayoutId == 0) {
            return null;
        }
        return (TabLayout)child.findViewById(this.mTabLayoutId);
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, V child, View dependency) {
        return super.onDependentViewChanged(parent, child, dependency);
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, V child, View dependency) {
        super.onDependentViewRemoved(parent, child, dependency);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, V child, View dependency) {
        if (dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            this.updateSnackbar((View)child, dependency);
            return true;
        }
        return super.layoutDependsOn(parent, child, dependency);
    }

    @Override
    public void onNestedVerticalOverScroll(CoordinatorLayout coordinatorLayout, V child, int direction, int currentOverScroll, int totalOverScroll) {
    }

    @Override
    public void onDirectionNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed, int scrollDirection) {
    }

    @Override
    protected boolean onNestedDirectionFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, int scrollDirection) {
        return false;
    }

    @Override
    public void onNestedScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        super.onNestedScroll(coordinatorLayout, child, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
        if (dyConsumed < 0) {
            this.handleDirection(child, -1);
        } else if (dyConsumed > 0) {
            this.handleDirection(child, 1);
        }
    }

    @Override
    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V child, View directTargetChild, View target, int nestedScrollAxes) {
        return nestedScrollAxes == 2 || super.onStartNestedScroll(coordinatorLayout, child, directTargetChild, target, nestedScrollAxes);
    }

    private void handleDirection(V child, int scrollDirection) {
        if (!this.behaviorTranslationEnabled) {
            return;
        }
        if (scrollDirection == -1 && this.hidden) {
            this.hidden = false;
            this.animateOffset(child, 0, false, true);
        } else if (scrollDirection == 1 && !this.hidden) {
            this.hidden = true;
            this.animateOffset(child, child.getHeight(), false, true);
        }
    }

    private void animateOffset(V child, int offset, boolean forceAnimation, boolean withAnimation) {
        if (!this.behaviorTranslationEnabled && !forceAnimation) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            this.ensureOrCancelObjectAnimation(child, offset, withAnimation);
            this.translationObjectAnimator.start();
        } else {
            this.ensureOrCancelAnimator(child, withAnimation);
            this.translationAnimator.translationY((float)offset).start();
        }
    }

    private void ensureOrCancelAnimator(V child, boolean withAnimation) {
        if (this.translationAnimator == null) {
            this.translationAnimator = ViewCompat.animate(child);
            this.translationAnimator.setDuration(withAnimation ? 300L : 0L);
            this.translationAnimator.setUpdateListener(new ViewPropertyAnimatorUpdateListener(){

                public void onAnimationUpdate(View view) {
                    if (AHBottomNavigationBehavior.this.navigationPositionListener != null) {
                        AHBottomNavigationBehavior.this.navigationPositionListener.onPositionChange((int)((float)view.getMeasuredHeight() - view.getTranslationY() + AHBottomNavigationBehavior.this.snackBarY));
                    }
                }
            });
            this.translationAnimator.setInterpolator(INTERPOLATOR);
        } else {
            this.translationAnimator.setDuration(withAnimation ? 300L : 0L);
            this.translationAnimator.cancel();
        }
    }

    private void ensureOrCancelObjectAnimation(V child, int offset, boolean withAnimation) {
        if (this.translationObjectAnimator != null) {
            this.translationObjectAnimator.cancel();
        }
        this.translationObjectAnimator = ObjectAnimator.ofFloat(child, (Property)View.TRANSLATION_Y, (float[])new float[]{offset});
        this.translationObjectAnimator.setDuration(withAnimation ? 300L : 0L);
        this.translationObjectAnimator.setInterpolator((TimeInterpolator)INTERPOLATOR);
        this.translationObjectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((View)child){
            final /* synthetic */ View val$child;
            {
                this.val$child = view;
            }

            public void onAnimationUpdate(ValueAnimator animation) {
                if (AHBottomNavigationBehavior.this.snackbarLayout != null && AHBottomNavigationBehavior.this.snackbarLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    AHBottomNavigationBehavior.this.targetOffset = (float)this.val$child.getMeasuredHeight() - this.val$child.getTranslationY();
                    ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)AHBottomNavigationBehavior.this.snackbarLayout.getLayoutParams();
                    p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)AHBottomNavigationBehavior.this.targetOffset);
                    AHBottomNavigationBehavior.this.snackbarLayout.requestLayout();
                }
                if (AHBottomNavigationBehavior.this.navigationPositionListener != null) {
                    AHBottomNavigationBehavior.this.navigationPositionListener.onPositionChange((int)((float)this.val$child.getMeasuredHeight() - this.val$child.getTranslationY() + AHBottomNavigationBehavior.this.snackBarY));
                }
            }
        });
    }

    public static <V extends View> AHBottomNavigationBehavior<V> from(V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof AHBottomNavigationBehavior)) {
            throw new IllegalArgumentException("The view is not associated with AHBottomNavigationBehavior");
        }
        return (AHBottomNavigationBehavior)behavior;
    }

    public void setTabLayoutId(int tabId) {
        this.mTabLayoutId = tabId;
    }

    public void setBehaviorTranslationEnabled(boolean behaviorTranslationEnabled, int navigationBarHeight) {
        this.behaviorTranslationEnabled = behaviorTranslationEnabled;
        this.navigationBarHeight = navigationBarHeight;
    }

    public void setOnNavigationPositionListener(AHBottomNavigation.OnNavigationPositionListener navigationHeightListener) {
        this.navigationPositionListener = navigationHeightListener;
    }

    public void removeOnNavigationPositionListener() {
        this.navigationPositionListener = null;
    }

    public void hideView(V view, int offset, boolean withAnimation) {
        if (!this.hidden) {
            this.hidden = true;
            this.animateOffset(view, offset, true, withAnimation);
        }
    }

    public void resetOffset(V view, boolean withAnimation) {
        if (this.hidden) {
            this.hidden = false;
            this.animateOffset(view, 0, true, withAnimation);
        }
    }

    public void updateSnackbar(View child, View dependency) {
        if (dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            this.snackbarLayout = (Snackbar.SnackbarLayout)dependency;
            if (this.mSnackbarHeight == -1) {
                this.mSnackbarHeight = dependency.getHeight();
            }
            int targetMargin = (int)((float)child.getMeasuredHeight() - child.getTranslationY());
            if (Build.VERSION.SDK_INT < 21) {
                child.bringToFront();
            }
            if (dependency.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)dependency.getLayoutParams();
                p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, targetMargin);
                dependency.requestLayout();
            }
        }
    }
}

