/*
 * Decompiled with CFR 0.152.
 */
package com.wildma.idcardcamera.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import java.util.ArrayList;

public class PermissionUtils {
    public static boolean checkPermissionFirst(Context context, int requestCode, String[] permission2) {
        ArrayList<String> permissions = new ArrayList<String>();
        for (String per : permission2) {
            int permissionCode = ActivityCompat.checkSelfPermission((Context)context, (String)per);
            if (permissionCode == 0) continue;
            permissions.add(per);
        }
        if (!permissions.isEmpty()) {
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])permissions.toArray(new String[permissions.size()]), (int)requestCode);
            return false;
        }
        return true;
    }

    public static boolean checkPermissionSecond(Context context, int requestCode, String[] permission2) {
        ArrayList<String> permissions = new ArrayList<String>();
        for (String per : permission2) {
            int permissionCode = ActivityCompat.checkSelfPermission((Context)context, (String)per);
            if (permissionCode == 0) continue;
            permissions.add(per);
        }
        if (!permissions.isEmpty()) {
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])permissions.toArray(new String[permissions.size()]), (int)requestCode);
            Intent localIntent = new Intent();
            localIntent.addFlags(0x10000000);
            if (Build.VERSION.SDK_INT >= 9) {
                localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                localIntent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
            } else if (Build.VERSION.SDK_INT <= 8) {
                localIntent.setAction("android.intent.action.VIEW");
                localIntent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
                localIntent.putExtra("com.android.settings.ApplicationPkgName", context.getPackageName());
            }
            context.startActivity(localIntent);
            return false;
        }
        return true;
    }
}

