/*
 * Decompiled with CFR 0.152.
 */
package com.wildma.idcardcamera.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import com.wildma.idcardcamera.camera.CameraActivity;
import java.lang.ref.WeakReference;

public class IDCardCamera {
    public static final int TYPE_IDCARD_FRONT = 1;
    public static final int TYPE_IDCARD_BACK = 2;
    public static final int RESULT_CODE = 17;
    public static final int PERMISSION_CODE_FIRST = 18;
    public static final String TAKE_TYPE = "take_type";
    public static final String IMAGE_PATH = "image_path";
    private final WeakReference<Activity> mActivity;
    private final WeakReference<Fragment> mFragment;

    public static IDCardCamera create(Activity activity) {
        return new IDCardCamera(activity);
    }

    public static IDCardCamera create(Fragment fragment) {
        return new IDCardCamera(fragment);
    }

    private IDCardCamera(Activity activity) {
        this(activity, null);
    }

    private IDCardCamera(Fragment fragment) {
        this((Activity)fragment.getActivity(), fragment);
    }

    private IDCardCamera(Activity activity, Fragment fragment) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.mFragment = new WeakReference<Fragment>(fragment);
    }

    public void openCamera(int IDCardDirection) {
        Activity activity = (Activity)this.mActivity.get();
        Fragment fragment = (Fragment)this.mFragment.get();
        Intent intent = new Intent((Context)activity, CameraActivity.class);
        intent.putExtra(TAKE_TYPE, IDCardDirection);
        if (fragment != null) {
            fragment.startActivityForResult(intent, IDCardDirection);
        } else {
            activity.startActivityForResult(intent, IDCardDirection);
        }
    }

    public static String getImagePath(Intent data) {
        if (data != null) {
            return data.getStringExtra(IMAGE_PATH);
        }
        return "";
    }
}

