/*
 * Decompiled with CFR 0.152.
 */
package com.wildma.idcardcamera.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.wildma.idcardcamera.R;
import com.wildma.idcardcamera.camera.CameraPreview;
import com.wildma.idcardcamera.camera.CameraUtils;
import com.wildma.idcardcamera.cropper.CropImageView;
import com.wildma.idcardcamera.cropper.CropListener;
import com.wildma.idcardcamera.utils.CommonUtils;
import com.wildma.idcardcamera.utils.FileUtils;
import com.wildma.idcardcamera.utils.ImageUtils;
import com.wildma.idcardcamera.utils.PermissionUtils;
import com.wildma.idcardcamera.utils.ScreenUtils;
import java.io.File;

public class CameraActivity
extends Activity
implements View.OnClickListener {
    private CropImageView mCropImageView;
    private Bitmap mCropBitmap;
    private CameraPreview mCameraPreview;
    private View mLlCameraCropContainer;
    private ImageView mIvCameraCrop;
    private ImageView mIvCameraFlash;
    private View mLlCameraOption;
    private View mLlCameraResult;
    private TextView mViewCameraCropBottom;
    private FrameLayout mFlCameraOption;
    private View mViewCameraCropLeft;
    private int mType;
    private boolean isToast = true;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean checkPermissionFirst = PermissionUtils.checkPermissionFirst((Context)this, 18, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.CAMERA"});
        if (checkPermissionFirst) {
            this.init();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        boolean isPermissions = true;
        for (int i = 0; i < permissions.length; ++i) {
            if (grantResults[i] != -1) continue;
            isPermissions = false;
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permissions[i]) || !this.isToast) continue;
            Toast.makeText((Context)this, (CharSequence)"\u8bf7\u624b\u52a8\u6253\u5f00\u8be5\u5e94\u7528\u9700\u8981\u7684\u6743\u9650", (int)0).show();
            this.isToast = false;
        }
        this.isToast = true;
        if (isPermissions) {
            Log.d((String)"onRequestPermission", (String)"onRequestPermissionsResult: \u5141\u8bb8\u6240\u6709\u6743\u9650");
            this.init();
        } else {
            Log.d((String)"onRequestPermission", (String)"onRequestPermissionsResult: \u6709\u6743\u9650\u4e0d\u5141\u8bb8");
            this.finish();
        }
    }

    private void init() {
        this.setContentView(R.layout.activity_camera);
        this.mType = this.getIntent().getIntExtra("take_type", 0);
        this.setRequestedOrientation(0);
        this.initView();
        this.initListener();
    }

    private void initView() {
        this.mCameraPreview = (CameraPreview)this.findViewById(R.id.camera_preview);
        this.mLlCameraCropContainer = this.findViewById(R.id.ll_camera_crop_container);
        this.mIvCameraCrop = (ImageView)this.findViewById(R.id.iv_camera_crop);
        this.mIvCameraFlash = (ImageView)this.findViewById(R.id.iv_camera_flash);
        this.mLlCameraOption = this.findViewById(R.id.ll_camera_option);
        this.mLlCameraResult = this.findViewById(R.id.ll_camera_result);
        this.mCropImageView = (CropImageView)this.findViewById(R.id.crop_image_view);
        this.mViewCameraCropBottom = (TextView)this.findViewById(R.id.view_camera_crop_bottom);
        this.mFlCameraOption = (FrameLayout)this.findViewById(R.id.fl_camera_option);
        this.mViewCameraCropLeft = this.findViewById(R.id.view_camera_crop_left);
        float screenMinSize = Math.min(ScreenUtils.getScreenWidth((Context)this), ScreenUtils.getScreenHeight((Context)this));
        float screenMaxSize = Math.max(ScreenUtils.getScreenWidth((Context)this), ScreenUtils.getScreenHeight((Context)this));
        float height = (int)((double)screenMinSize * 0.75);
        float width = (int)(height * 75.0f / 47.0f);
        float flCameraOptionWidth = (screenMaxSize - width) / 2.0f;
        LinearLayout.LayoutParams containerParams = new LinearLayout.LayoutParams((int)width, -1);
        LinearLayout.LayoutParams cropParams = new LinearLayout.LayoutParams((int)width, (int)height);
        LinearLayout.LayoutParams cameraOptionParams = new LinearLayout.LayoutParams((int)flCameraOptionWidth, -1);
        this.mLlCameraCropContainer.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        this.mIvCameraCrop.setLayoutParams((ViewGroup.LayoutParams)cropParams);
        this.mFlCameraOption.setLayoutParams((ViewGroup.LayoutParams)cameraOptionParams);
        switch (this.mType) {
            case 1: {
                this.mIvCameraCrop.setImageResource(R.mipmap.camera_idcard_front);
                break;
            }
            case 2: {
                this.mIvCameraCrop.setImageResource(R.mipmap.camera_idcard_back);
            }
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                CameraActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CameraActivity.this.mCameraPreview.setVisibility(0);
                    }
                });
            }
        }, 500L);
    }

    private void initListener() {
        this.mCameraPreview.setOnClickListener(this);
        this.mIvCameraFlash.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.iv_camera_close).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.iv_camera_take).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.iv_camera_result_ok).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.iv_camera_result_cancel).setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.camera_preview) {
            this.mCameraPreview.focus();
        } else if (id2 == R.id.iv_camera_close) {
            this.finish();
        } else if (id2 == R.id.iv_camera_take) {
            if (!CommonUtils.isFastClick()) {
                this.takePhoto();
            }
        } else if (id2 == R.id.iv_camera_flash) {
            if (CameraUtils.hasFlash((Context)this)) {
                boolean isFlashOn = this.mCameraPreview.switchFlashLight();
                this.mIvCameraFlash.setImageResource(isFlashOn ? R.mipmap.camera_flash_on : R.mipmap.camera_flash_off);
            } else {
                Toast.makeText((Context)this, (int)R.string.no_flash, (int)0).show();
            }
        } else if (id2 == R.id.iv_camera_result_ok) {
            this.confirm();
        } else if (id2 == R.id.iv_camera_result_cancel) {
            this.mCameraPreview.setEnabled(true);
            this.mCameraPreview.addCallback();
            this.mCameraPreview.startPreview();
            this.mIvCameraFlash.setImageResource(R.mipmap.camera_flash_off);
            this.setTakePhotoLayout();
        }
    }

    private void takePhoto() {
        this.mCameraPreview.setEnabled(false);
        CameraUtils.getCamera().setOneShotPreviewCallback(new Camera.PreviewCallback(){

            public void onPreviewFrame(final byte[] bytes, Camera camera) {
                final Camera.Size size = camera.getParameters().getPreviewSize();
                camera.stopPreview();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int w = size.width;
                        int h = size.height;
                        Bitmap bitmap = ImageUtils.getBitmapFromByte(bytes, w, h);
                        CameraActivity.this.cropImage(bitmap);
                    }
                }).start();
            }
        });
    }

    private void cropImage(Bitmap bitmap) {
        float left = this.mViewCameraCropLeft.getWidth();
        float top = this.mIvCameraCrop.getTop();
        float right = (float)this.mIvCameraCrop.getRight() + left;
        float bottom = this.mIvCameraCrop.getBottom();
        float leftProportion = left / (float)this.mCameraPreview.getWidth();
        float topProportion = top / (float)this.mCameraPreview.getHeight();
        float rightProportion = right / (float)this.mCameraPreview.getWidth();
        float bottomProportion = bottom / (float)this.mCameraPreview.getBottom();
        this.mCropBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)(leftProportion * (float)bitmap.getWidth())), (int)((int)(topProportion * (float)bitmap.getHeight())), (int)((int)((rightProportion - leftProportion) * (float)bitmap.getWidth())), (int)((int)((bottomProportion - topProportion) * (float)bitmap.getHeight())));
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CameraActivity.this.mCropImageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(CameraActivity.this.mIvCameraCrop.getWidth(), CameraActivity.this.mIvCameraCrop.getHeight()));
                CameraActivity.this.setCropLayout();
                CameraActivity.this.mCropImageView.setImageBitmap(CameraActivity.this.mCropBitmap);
            }
        });
    }

    private void setCropLayout() {
        this.mIvCameraCrop.setVisibility(8);
        this.mCameraPreview.setVisibility(8);
        this.mLlCameraOption.setVisibility(8);
        this.mCropImageView.setVisibility(0);
        this.mLlCameraResult.setVisibility(0);
        this.mViewCameraCropBottom.setText((CharSequence)"");
    }

    private void setTakePhotoLayout() {
        this.mIvCameraCrop.setVisibility(0);
        this.mCameraPreview.setVisibility(0);
        this.mLlCameraOption.setVisibility(0);
        this.mCropImageView.setVisibility(8);
        this.mLlCameraResult.setVisibility(8);
        this.mViewCameraCropBottom.setText((CharSequence)this.getString(R.string.touch_to_focus));
        this.mCameraPreview.focus();
    }

    private void confirm() {
        this.mCropImageView.crop(new CropListener(){

            @Override
            public void onFinish(Bitmap bitmap) {
                String imagePath;
                if (bitmap == null) {
                    Toast.makeText((Context)CameraActivity.this.getApplicationContext(), (CharSequence)CameraActivity.this.getString(R.string.crop_fail), (int)0).show();
                    CameraActivity.this.finish();
                }
                if (ImageUtils.save(bitmap, imagePath = new StringBuffer().append(FileUtils.getImageCacheDir((Context)CameraActivity.this)).append(File.separator).append(System.currentTimeMillis()).append(".jpg").toString(), Bitmap.CompressFormat.JPEG)) {
                    Intent intent = new Intent();
                    intent.putExtra("image_path", imagePath);
                    CameraActivity.this.setResult(17, intent);
                    CameraActivity.this.finish();
                }
            }
        }, true);
    }

    protected void onStart() {
        super.onStart();
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onStart();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mCameraPreview != null) {
            this.mCameraPreview.onStop();
        }
    }
}

