/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.util;

import android.content.SharedPreferences;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import tech.linjiang.pandora.util.Utils;

public class Config {
    private static final String NAME = "pd_config";
    private static final String KEY_NET = "key_net";
    private static final String KEY_SHAKE_SWITCH = "key_shake_switch";
    private static final String KEY_SHAKE_THRESHOLD = "key_shake_threshold";
    private static final String KEY_NETWORK_DELAY_REQ = "key_network_delay_req";
    private static final String KEY_NETWORK_DELAY_RES = "key_network_delay_res";
    private static final String KEY_SANDBOX_DPM = "key_sandbox_dpm";
    private static final String KEY_NETWORK_PAGE_SIZE = "key_network_page_size";
    private static final String KEY_NETWORK_URLCONNECTION = "key_network_urlconnection";
    private static final String KEY_UI_ACTIVITY_GRAVITY = "key_ui_activity_gravity";
    private static final String KEY_UI_GRID_INTERVAL = "key_ui_grid_interval";
    private static final String KEY_UI_IGNORE_SYS_LAYER = "key_ui_ignore_sys_layer";
    private static final String KEY_INTERNAL_DRAG_Y = "key_internal_drag_y";
    private static final String KEY_PERMISSION = "key_permission";
    private static final boolean DEF_KEY_SHAKE_SWITCH = true;
    private static final int DEF_KEY_SHAKE_THRESHOLD = 1000;
    private static final long DEF_KEY_NETWORK_DELAY_REQ = 0L;
    private static final long DEF_KEY_NETWORK_DELAY_RES = 0L;
    private static final boolean DEF_KEY_SANDBOX_DPM = false;
    private static final int DEF_KEY_NETWORK_PAGE_SIZE = 512;
    private static final boolean DEF_KEY_NETWORK_URLCONNECTION = true;
    private static final int DEF_UI_ACTIVITY_GRAVITY = 8388691;
    private static final int DEF_UI_GRID_INTERVAL = 5;
    private static final boolean DEF_UI_IGNORE_SYS_LAYER = false;
    private static final int DEF_INTERNAL_DRAG_Y = 0;

    public static void setNetLogEnable(boolean enable) {
        Config.getSp().edit().putBoolean(KEY_NET, enable).apply();
    }

    public static boolean isNetLogEnable() {
        return Config.getSp().getBoolean(KEY_NET, true);
    }

    public static void setDragY(float y) {
        Config.getSp().edit().putFloat(KEY_INTERNAL_DRAG_Y, y).apply();
    }

    public static float getDragY() {
        return Config.getSp().getFloat(KEY_INTERNAL_DRAG_Y, 0.0f);
    }

    public static void setPermissionChecked() {
        Config.getSp().edit().putBoolean(KEY_PERMISSION, true).apply();
    }

    public static boolean ifPermissionChecked() {
        return Config.getSp().getBoolean(KEY_PERMISSION, false);
    }

    private static SharedPreferences getSp() {
        return Utils.getContext().getSharedPreferences(NAME, 0);
    }

    public static void reset() {
        Config.getSp().edit().clear().apply();
    }

    public static boolean getSHAKE_SWITCH() {
        return Config.getSp().getBoolean(KEY_SHAKE_SWITCH, true);
    }

    public static void setSHAKE_SWITCH(Boolean value) {
        Config.getSp().edit().putBoolean(KEY_SHAKE_SWITCH, value.booleanValue()).apply();
    }

    public static int getSHAKE_THRESHOLD() {
        return Config.getSp().getInt(KEY_SHAKE_THRESHOLD, 1000);
    }

    public static void setSHAKE_THRESHOLD(int value) {
        Config.getSp().edit().putInt(KEY_SHAKE_THRESHOLD, value).apply();
    }

    public static int getUI_ACTIVITY_GRAVITY() {
        return Config.getSp().getInt(KEY_UI_ACTIVITY_GRAVITY, 8388691);
    }

    public static void setUI_ACTIVITY_GRAVITY(int value) {
        Config.getSp().edit().putInt(KEY_UI_ACTIVITY_GRAVITY, value).apply();
    }

    public static int getUI_GRID_INTERVAL() {
        return Config.getSp().getInt(KEY_UI_GRID_INTERVAL, 5);
    }

    public static void setUI_GRID_INTERVAL(int value) {
        Config.getSp().edit().putInt(KEY_UI_GRID_INTERVAL, value).apply();
    }

    public static long getNETWORK_DELAY_REQ() {
        return Config.getSp().getLong(KEY_NETWORK_DELAY_REQ, 0L);
    }

    public static void setNETWORK_DELAY_REQ(long value) {
        Config.getSp().edit().putLong(KEY_NETWORK_DELAY_REQ, value).apply();
    }

    public static long getNETWORK_DELAY_RES() {
        return Config.getSp().getLong(KEY_NETWORK_DELAY_RES, 0L);
    }

    public static void setNETWORK_DELAY_RES(long value) {
        Config.getSp().edit().putLong(KEY_NETWORK_DELAY_RES, value).apply();
    }

    public static boolean getSANDBOX_DPM() {
        return Config.getSp().getBoolean(KEY_SANDBOX_DPM, false);
    }

    public static void setSANDBOX_DPM(boolean value) {
        Config.getSp().edit().putBoolean(KEY_SANDBOX_DPM, value).apply();
    }

    public static int getNETWORK_PAGE_SIZE() {
        return Config.getSp().getInt(KEY_NETWORK_PAGE_SIZE, 512);
    }

    public static void setNETWORK_PAGE_SIZE(int value) {
        Config.getSp().edit().putInt(KEY_NETWORK_PAGE_SIZE, value).apply();
    }

    public static boolean getNETWORK_URL_CONNECTION() {
        return Config.getSp().getBoolean(KEY_NETWORK_URLCONNECTION, true);
    }

    public static void setNETWORK_URL_CONNECTION(boolean value) {
        Config.getSp().edit().putBoolean(KEY_NETWORK_URLCONNECTION, value).apply();
    }

    public static boolean getUI_IGNORE_SYS_LAYER() {
        return Config.getSp().getBoolean(KEY_UI_IGNORE_SYS_LAYER, false);
    }

    public static void setUI_IGNORE_SYS_LAYER(Boolean value) {
        Config.getSp().edit().putBoolean(KEY_UI_IGNORE_SYS_LAYER, value.booleanValue()).apply();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
        public static final int SHAKE_SWITCH = 1;
        public static final int SHAKE_THRESHOLD = 2;
        public static final int COMMON_NETWORK_SWITCH = 17;
        public static final int COMMON_SANDBOX_SWITCH = 18;
        public static final int COMMON_UI_SWITCH = 19;
        public static final int NETWORK_DELAY_REQ = 32;
        public static final int NETWORK_DELAY_RES = 33;
        public static final int NETWORK_PAGE_SIZE = 34;
        public static final int SANDBOX_DPM = 48;
        public static final int UI_ACTIVITY_GRAVITY = 64;
        public static final int UI_GRID_INTERVAL = 65;
        public static final int UI_IGNORE_SYS_LAYER = 66;
    }
}

