/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.item.FuncItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class FuncView
extends LinearLayout {
    private static final String TAG = "PanelView";
    private UniversalAdapter adapter;
    private float lastY;
    private View.OnTouchListener touchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    FuncView.this.lastY = event.getRawY();
                    break;
                }
                case 2: {
                    WindowManager.LayoutParams params = (WindowManager.LayoutParams)FuncView.this.getLayoutParams();
                    params.y = (int)((float)params.y + (event.getRawY() - FuncView.this.lastY));
                    params.y = Math.max(0, params.y);
                    Utils.updateViewLayoutInWindow((View)FuncView.this, params);
                    FuncView.this.lastY = event.getRawY();
                    Utils.cancelTask(FuncView.this.task);
                    Utils.postDelayed(FuncView.this.task, 200L);
                    break;
                }
            }
            return true;
        }
    };
    private Runnable task = new Runnable(){

        @Override
        public void run() {
            Config.setDragY(FuncView.this.lastY);
        }
    };

    @SuppressLint(value={"ClickableViewAccessibility"})
    public FuncView(Context context) {
        super(context);
        this.setOrientation(0);
        this.setBackgroundResource(R.drawable.pd_shadow_131124);
        ImageView moveView = new ImageView(context);
        RecyclerView recyclerView = new RecyclerView(context);
        ImageView closeView = new ImageView(context);
        moveView.setImageResource(R.drawable.pd_drag);
        moveView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        moveView.setOnTouchListener(this.touchListener);
        closeView.setImageResource(R.drawable.pd_close);
        closeView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        closeView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuncView.this.close();
            }
        });
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, 0, false));
        this.adapter = new UniversalAdapter();
        recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.addView((View)moveView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(ViewKnife.dip2px(24.0f), -1));
        this.addView((View)recyclerView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        this.addView((View)closeView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(ViewKnife.dip2px(40.0f), -1));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int maxWidth = this.getResources().getConfiguration().orientation == 1 ? ViewKnife.dip2px(64.0f) + ViewKnife.dip2px(50.0f) * 5 + ViewKnife.dip2px(24.0f) : View.MeasureSpec.getSize((int)widthMeasureSpec);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)Math.min(View.MeasureSpec.getSize((int)widthMeasureSpec), maxWidth), (int)View.MeasureSpec.getMode((int)widthMeasureSpec)), heightMeasureSpec);
    }

    public void addItem(@DrawableRes int icon, String name) {
        this.adapter.insertItem(new FuncItem(icon, name));
    }

    public void setOnItemClickListener(final OnItemClickListener listener) {
        this.adapter.setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                boolean selected = listener.onItemClick(position);
                ((FuncItem)item).setSelected(selected);
                FuncView.this.adapter.notifyItemChanged(position);
            }
        });
    }

    public boolean open() {
        if (ViewCompat.isAttachedToWindow((View)this)) {
            return true;
        }
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.width = -2;
        params.height = ViewKnife.dip2px(62.0f);
        params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
        params.flags = 8;
        params.format = -3;
        params.gravity = 0x800033;
        params.x = 0;
        params.y = (int)Config.getDragY();
        return Utils.addViewToWindow((View)this, params);
    }

    public void close() {
        if (ViewCompat.isAttachedToWindow((View)this)) {
            Utils.removeViewFromWindow((View)this);
        }
    }

    public boolean isVisible() {
        return this.getVisibility() == 0;
    }

    public static interface OnItemClickListener {
        public boolean onItemClick(int var1);
    }
}

