/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.item;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;

public class RouteParamItem
extends BaseItem<Integer> {
    private String input1;
    private String input2;
    private int flagType;
    private int whichIdInput;
    private boolean isEditRequesting;
    private EditListener listener;
    private View.OnClickListener clickListener = new View.OnClickListener(){

        public void onClick(View v) {
            RouteParamItem.this.whichIdInput = v.getId();
            TextView tv = (TextView)v;
            RouteParamItem.this.isEditRequesting = true;
            if (RouteParamItem.this.listener != null) {
                RouteParamItem.this.listener.onEditReq(tv.getText().toString(), RouteParamItem.this.whichIdInput == R.id.input1 ? 0 : (Integer)RouteParamItem.this.data);
            }
        }
    };

    public RouteParamItem(Integer type) {
        super(type);
    }

    public RouteParamItem(Integer type, EditListener listener) {
        super(type);
        this.listener = listener;
    }

    public int getFlagType() {
        return this.flagType;
    }

    public String getInput1() {
        return this.input1;
    }

    public String getInput2() {
        return this.input2;
    }

    public boolean HasInput() {
        return !TextUtils.isEmpty((CharSequence)this.input1) && !TextUtils.isEmpty((CharSequence)this.input2);
    }

    public void setFlagType(int flagType, String name) {
        this.flagType = flagType;
        this.input2 = name;
    }

    public boolean isEditRequesting() {
        return this.isEditRequesting;
    }

    public void setTheEditResult(String value) {
        this.isEditRequesting = false;
        if (this.whichIdInput == R.id.input1) {
            this.input1 = value;
        } else {
            this.input2 = value;
        }
    }

    @Override
    public void onBinding(int position, UniversalAdapter.ViewPool pool, Integer data) {
        pool.getView(R.id.input1).setVisibility(-1 == data ? 8 : 0);
        pool.getView(R.id.input2).setEnabled(-1 != data);
        pool.setText(R.id.type, RouteParamItem.getTypeName(data)).setText(R.id.input1, this.input1).setText(R.id.input2, this.input2);
        pool.getView(R.id.input1).setTag((Object)0);
        pool.getView(R.id.input1).setOnClickListener(this.clickListener);
        pool.getView(R.id.input2).setTag((Object)1);
        pool.getView(R.id.input2).setOnClickListener(this.clickListener);
    }

    @Override
    public int getLayout() {
        return R.layout.pd_item_route_param;
    }

    private static String getTypeName(int type) {
        switch (type) {
            case 1: {
                return "boolean";
            }
            case 5: {
                return "double";
            }
            case -1: {
                return "flag";
            }
            case 4: {
                return "float";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "long";
            }
            case 0: {
                return "String";
            }
        }
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
        public static final int NONE = -1;
        public static final int STRING = 0;
        public static final int BOOLEAN = 1;
        public static final int INT = 2;
        public static final int LONG = 3;
        public static final int FLOAT = 4;
        public static final int DOUBLE = 5;
    }

    public static interface EditListener {
        public void onEditReq(String var1, int var2);
    }
}

