/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.cache.History;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.item.KeyValueItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class HistoryFragment
extends BaseListFragment {
    @Override
    protected boolean enableSwipeBack() {
        return false;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Activity History");
        this.getToolbar().getMenu().add(-1, 0, 0, R.string.pd_name_delete_key).setIcon(R.drawable.pd_delete).setShowAsAction(2);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                History.clear();
                HistoryFragment.this.getAdapter().clearItems();
                Utils.toast(R.string.pd_success);
                return true;
            }
        });
        this.loadData();
    }

    private void loadData() {
        this.hideError();
        this.showLoading();
        new SimpleTask<Void, List<History>>(new SimpleTask.Callback<Void, List<History>>(){

            public List<History> doInBackground(Void[] params) {
                return History.query();
            }

            @Override
            public void onPostExecute(List<History> result) {
                HistoryFragment.this.hideLoading();
                ArrayList<BaseItem> data = new ArrayList<BaseItem>(result.size());
                if (Utils.isNotEmpty(result)) {
                    data.add(new TitleItem("Task"));
                    for (History history : result) {
                        String[] value = new String[]{history.activity, history.event};
                        data.add(new KeyValueItem(value, false, false, Utils.millis2String(history.createTime, Utils.HHMMSS)));
                    }
                    HistoryFragment.this.getAdapter().setItems(data);
                } else {
                    HistoryFragment.this.showError(null);
                }
            }
        }).execute(new Void[0]);
    }
}

