/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.cache;

import android.util.Pair;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import tech.linjiang.pandora.cache.CacheDatabase;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;

@CacheDatabase.Table(value="http_summary")
public class Summary {
    @CacheDatabase.Column(value="_id", primaryKey=true)
    public long id;
    @CacheDatabase.Column(value="status")
    public int status;
    @CacheDatabase.Column(value="code")
    public int code;
    @CacheDatabase.Column(value="url")
    public String url;
    @CacheDatabase.Column(value="query")
    public String query;
    @CacheDatabase.Column(value="host")
    public String host;
    @CacheDatabase.Column(value="method")
    public String method;
    @CacheDatabase.Column(value="protocol")
    public String protocol;
    @CacheDatabase.Column(value="ssl")
    public boolean ssl;
    @CacheDatabase.Column(value="start_time")
    public long start_time;
    @CacheDatabase.Column(value="end_time")
    public long end_time;
    @CacheDatabase.Column(value="request_content_type")
    public String request_content_type;
    @CacheDatabase.Column(value="response_content_type")
    public String response_content_type;
    @CacheDatabase.Column(value="request_size")
    public long request_size;
    @CacheDatabase.Column(value="response_size")
    public long response_size;
    @CacheDatabase.Column(value="request_header")
    public String requestHeader;
    @CacheDatabase.Column(value="response_header")
    public String responseHeader;
    public List<Pair<String, String>> request_header;
    public List<Pair<String, String>> response_header;

    public static List<Summary> queryList() {
        String condition = "order by start_time desc limit " + String.valueOf(Config.getNETWORK_PAGE_SIZE());
        List<Summary> result = CacheDatabase.queryList(Summary.class, null, condition);
        return result;
    }

    public static Summary query(long id) {
        List<Summary> result = CacheDatabase.queryList(Summary.class, "_id = " + String.valueOf(id), "limit 1");
        if (Utils.isNotEmpty(result)) {
            return result.get(0);
        }
        return null;
    }

    public static long insert(Summary summary) {
        return CacheDatabase.insert(summary);
    }

    public static void update(Summary summary) {
        CacheDatabase.update(summary);
    }

    public static void clear() {
        CacheDatabase.delete(Summary.class);
    }

    static {
        Summary.clear();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
        public static final int REQUESTING = 0;
        public static final int ERROR = 1;
        public static final int COMPLETE = 2;
    }
}

