/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.database;

import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DatabaseResult {
    private static final int MAX_BLOB_LENGTH = 512;
    private static final String UNKNOWN_BLOB_LABEL = "{blob}";
    public List<String> columnNames;
    public List<List<String>> values;
    public Error sqlError;

    public void transformRawQuery() throws SQLiteException {
    }

    public void transformSelect(Cursor result) throws SQLiteException {
        this.columnNames = Arrays.asList(result.getColumnNames());
        this.values = DatabaseResult.wrapRows(result);
    }

    public void transformInsert(long insertedId) throws SQLiteException {
    }

    public void transformUpdateDelete(int count) throws SQLiteException {
    }

    private static List<List<String>> wrapRows(Cursor cursor) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        int numColumns = cursor.getColumnCount();
        while (cursor.moveToNext()) {
            ArrayList<String> flatList = new ArrayList<String>();
            block7: for (int column = 0; column < numColumns; ++column) {
                switch (cursor.getType(column)) {
                    case 0: {
                        flatList.add(null);
                        continue block7;
                    }
                    case 1: {
                        flatList.add(String.valueOf(cursor.getLong(column)));
                        continue block7;
                    }
                    case 2: {
                        flatList.add(String.valueOf(cursor.getDouble(column)));
                        continue block7;
                    }
                    case 4: {
                        flatList.add(DatabaseResult.blobToString(cursor.getBlob(column)));
                        continue block7;
                    }
                    default: {
                        flatList.add(cursor.getString(column));
                    }
                }
            }
            result.add(flatList);
        }
        return result;
    }

    private static String blobToString(byte[] blob) {
        if (blob.length <= 512 && DatabaseResult.fastIsAscii(blob)) {
            try {
                return new String(blob, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return UNKNOWN_BLOB_LABEL;
    }

    private static boolean fastIsAscii(byte[] blob) {
        for (byte b : blob) {
            if ((b & 0xFFFFFF80) == 0) continue;
            return false;
        }
        return true;
    }

    public static class Error {
        public String message;
        public int code;
    }
}

