/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.function.IFunc;
import tech.linjiang.pandora.inspector.CurInfoView;
import tech.linjiang.pandora.inspector.GridLineView;
import tech.linjiang.pandora.ui.Dispatcher;
import tech.linjiang.pandora.ui.view.FuncView;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

class FuncController
implements Application.ActivityLifecycleCallbacks,
FuncView.OnItemClickListener {
    private final FuncView funcView;
    private final CurInfoView curInfoView;
    private final GridLineView gridLineView;
    private int activeCount;
    private final List<IFunc> functions = new ArrayList<IFunc>();

    FuncController(Application app) {
        this.funcView = new FuncView((Context)app);
        this.funcView.setOnItemClickListener(this);
        this.curInfoView = new CurInfoView((Context)app);
        this.gridLineView = new GridLineView((Context)app);
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.addDefaultFunctions();
    }

    void addFunc(IFunc func) {
        if (!this.functions.contains(func)) {
            this.functions.add(func);
            this.funcView.addItem(func.getIcon(), func.getName());
        }
    }

    void open() {
        boolean succeed;
        if (this.funcView.isVisible() && !(succeed = this.funcView.open())) {
            Dispatcher.start(Utils.getContext(), 17);
        }
    }

    void close() {
        this.funcView.close();
    }

    private void showOverlay() {
        this.funcView.setVisibility(0);
        this.curInfoView.setVisibility(0);
        this.gridLineView.setVisibility(0);
    }

    private void hideOverlay() {
        this.funcView.setVisibility(8);
        this.curInfoView.setVisibility(8);
        this.gridLineView.setVisibility(8);
    }

    @Override
    public boolean onItemClick(int index) {
        return this.functions.get(index).onClick();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        ++this.activeCount;
        if (this.activeCount == 1) {
            this.showOverlay();
        }
    }

    public void onActivityResumed(Activity activity) {
        if (activity instanceof Dispatcher) {
            this.hideOverlay();
        }
        this.curInfoView.updateText(activity.getClass().getName());
    }

    public void onActivityPaused(Activity activity) {
        if (activity instanceof Dispatcher && this.activeCount > 0) {
            this.showOverlay();
        }
        this.curInfoView.updateText(null);
    }

    public void onActivityStopped(Activity activity) {
        --this.activeCount;
        if (this.activeCount <= 0) {
            this.hideOverlay();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private void addDefaultFunctions() {
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_network;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_network);
            }

            @Override
            public boolean onClick() {
                Dispatcher.start(Utils.getContext(), 1);
                return false;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_disk;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_sandbox);
            }

            @Override
            public boolean onClick() {
                Dispatcher.start(Utils.getContext(), 2);
                return false;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_select;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_select);
            }

            @Override
            public boolean onClick() {
                Dispatcher.start(Utils.getContext(), 6);
                return false;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_bug;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_crash);
            }

            @Override
            public boolean onClick() {
                Dispatcher.start(Utils.getContext(), 8);
                return false;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_layer;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_layer);
            }

            @Override
            public boolean onClick() {
                Dispatcher.start(Utils.getContext(), 3);
                return false;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_ruler;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_baseline);
            }

            @Override
            public boolean onClick() {
                Dispatcher.start(Utils.getContext(), 5);
                return false;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_map;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_navigate);
            }

            @Override
            public boolean onClick() {
                Dispatcher.start(Utils.getContext(), 16);
                return false;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_history;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_history);
            }

            @Override
            public boolean onClick() {
                Dispatcher.start(Utils.getContext(), 9);
                return false;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_windows;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_activity);
            }

            @Override
            public boolean onClick() {
                boolean isOpen = FuncController.this.curInfoView.isOpen();
                FuncController.this.curInfoView.toggle();
                return !isOpen;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_grid;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_gridline);
            }

            @Override
            public boolean onClick() {
                boolean isOpen = FuncController.this.gridLineView.isOpen();
                FuncController.this.gridLineView.toggle();
                return !isOpen;
            }
        });
        this.addFunc(new IFunc(){

            @Override
            public int getIcon() {
                return R.drawable.pd_config;
            }

            @Override
            public String getName() {
                return ViewKnife.getString(R.string.pd_name_config);
            }

            @Override
            public boolean onClick() {
                Dispatcher.start(Utils.getContext(), 7);
                return false;
            }
        });
    }
}

