/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v7.appcompat.R;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.File;
import tech.linjiang.pandora.cache.Content;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.connector.SimpleOnActionExpandListener;
import tech.linjiang.pandora.ui.connector.SimpleOnQueryTextListener;
import tech.linjiang.pandora.ui.fragment.BaseFragment;
import tech.linjiang.pandora.util.FileUtil;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class NetContentFragment
extends BaseFragment {
    private boolean showResponse;
    private long id;
    private String contentType;
    private String originContent;
    private WebView webView;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.showResponse = this.getArguments().getBoolean("param1", true);
        this.id = this.getArguments().getLong("param2");
        this.contentType = this.getArguments().getString("param3");
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected View getLayoutView() {
        this.webView = new WebView(this.getContext());
        this.webView.getSettings().setDefaultTextEncodingName("UTF-8");
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                NetContentFragment.this.loadData();
            }
        });
        return this.webView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Content");
        this.webView.loadUrl("file:///android_asset/tmp_json.html");
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.closeSoftInput();
    }

    @Override
    protected int getLayoutId() {
        return 0;
    }

    private void setupMenuView() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setSearchView();
        }
        this.getToolbar().getMenu().add(-1, 0, 1, R.string.pd_name_copy_value);
        this.getToolbar().getMenu().add(-1, 0, 2, R.string.pd_name_share);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            @RequiresApi(api=16)
            public boolean onMenuItemClick(MenuItem item) {
                if (item.getOrder() == 1) {
                    Utils.copy2ClipBoard(NetContentFragment.this.originContent);
                } else if (item.getOrder() == 2) {
                    NetContentFragment.this.saveAsFileAndShare(NetContentFragment.this.originContent);
                }
                return true;
            }
        });
    }

    @TargetApi(value=16)
    private void setSearchView() {
        MenuItem searchItem = this.getToolbar().getMenu().add(-1, 0, 0, R.string.pd_name_search);
        SearchView searchView = new SearchView(this.getContext());
        searchItem.setActionView((View)searchView).setIcon(R.drawable.pd_search).setShowAsAction(10);
        searchView.setInputType(144);
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)new SimpleOnQueryTextListener(){

            @Override
            public boolean onQueryTextChange(String newText) {
                NetContentFragment.this.webView.findAllAsync(newText.trim());
                return true;
            }

            @Override
            public boolean onQueryTextSubmit(String query) {
                NetContentFragment.this.closeSoftInput();
                return true;
            }
        });
        SimpleOnActionExpandListener.bind(searchItem, new SimpleOnActionExpandListener(){

            @Override
            public boolean onMenuItemActionCollapse(MenuItem item) {
                NetContentFragment.this.webView.clearMatches();
                return true;
            }
        });
        View closeView = searchView.findViewById(R.id.search_close_btn);
        if (closeView != null) {
            ((ViewGroup)closeView.getParent()).removeView(closeView);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(ViewKnife.dip2px(32.0f), -1);
        ImageView prevView = new ImageView(this.getContext());
        prevView.setImageResource(R.drawable.pd_up_down);
        prevView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        ImageView nextView = new ImageView(this.getContext());
        nextView.setImageResource(R.drawable.pd_up_down);
        nextView.setRotation(180.0f);
        nextView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        final TextView searchStats = new TextView(this.getContext());
        searchStats.setTextSize(10.0f);
        searchStats.setGravity(16);
        searchStats.setPadding(ViewKnife.dip2px(8.0f), 0, ViewKnife.dip2px(8.0f), 0);
        ((LinearLayout)searchView.getChildAt(0)).addView((View)searchStats, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        ((LinearLayout)searchView.getChildAt(0)).addView((View)prevView, (ViewGroup.LayoutParams)params);
        ((LinearLayout)searchView.getChildAt(0)).addView((View)nextView, (ViewGroup.LayoutParams)params);
        nextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NetContentFragment.this.webView.findNext(true);
            }
        });
        prevView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NetContentFragment.this.webView.findNext(false);
            }
        });
        this.webView.setFindListener(new WebView.FindListener(){

            public void onFindResultReceived(int position, int all, boolean b) {
                searchStats.setText((CharSequence)String.format("%s/%s", position + 1, all));
                searchStats.setVisibility(all > 0 ? 0 : 8);
            }
        });
    }

    private void saveAsFileAndShare(String msg) {
        this.showLoading();
        new SimpleTask<String, Intent>(new SimpleTask.Callback<String, Intent>(){

            public Intent doInBackground(String[] params) {
                String path = FileUtil.saveFile(params[0].getBytes(), "json", "txt");
                String newPath = FileUtil.fileCopy2Tmp(new File(path));
                if (!TextUtils.isEmpty((CharSequence)newPath)) {
                    return FileUtil.getFileIntent(newPath);
                }
                return null;
            }

            @Override
            public void onPostExecute(Intent result) {
                NetContentFragment.this.hideLoading();
                if (result != null) {
                    try {
                        NetContentFragment.this.startActivity(result);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Utils.toast(t.getMessage());
                    }
                } else {
                    Utils.toast(R.string.pd_failed);
                }
            }
        }).execute(new String[]{msg});
    }

    private void loadData() {
        this.showLoading();
        new SimpleTask<Void, String>(new SimpleTask.Callback<Void, String>(){

            public String doInBackground(Void[] params) {
                Content content = Content.query(NetContentFragment.this.id);
                String result = NetContentFragment.this.showResponse ? content.responseBody : content.requestBody;
                return result;
            }

            @Override
            public void onPostExecute(String result) {
                NetContentFragment.this.hideLoading();
                if (TextUtils.isEmpty((CharSequence)result)) {
                    Utils.toast(R.string.pd_error_msg);
                    return;
                }
                NetContentFragment.this.setupMenuView();
                NetContentFragment.this.originContent = result;
                NetContentFragment.this.webView.setWebViewClient(null);
                if (NetContentFragment.this.contentType != null && NetContentFragment.this.contentType.toLowerCase().contains("json")) {
                    result = result.replaceAll("\n", "");
                    result = result.replace("\\", "\\\\");
                    result = result.replace("'", "\\'");
                    if (Build.VERSION.SDK_INT < 19) {
                        NetContentFragment.this.webView.loadUrl(String.format("javascript:showJson('%s')", result));
                    } else {
                        NetContentFragment.this.webView.evaluateJavascript(String.format("showJson('%s')", result), null);
                    }
                } else {
                    NetContentFragment.this.webView.loadDataWithBaseURL(null, result, NetContentFragment.this.decideMimeType(), "utf-8", null);
                }
            }
        }).execute(new Void[0]);
    }

    private String decideMimeType() {
        if (this.contentType != null && this.contentType.toLowerCase().contains("xml")) {
            return "text/xml";
        }
        return "text/html";
    }
}

