/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.item;

import java.io.File;
import java.util.Locale;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.FileUtil;
import tech.linjiang.pandora.util.Utils;

public class FileItem
extends BaseItem<File> {
    private String info;

    public FileItem(File data) {
        super(data);
        this.info = !data.isDirectory() ? String.format(Locale.getDefault(), "%s    %s", FileUtil.fileSize(data), Utils.millis2String(data.lastModified(), Utils.NO_MILLIS)) : String.format(Locale.getDefault(), "%d items    %s", Utils.getCount(data.list()), Utils.millis2String(data.lastModified(), Utils.NO_MILLIS));
    }

    @Override
    public void onBinding(int position, UniversalAdapter.ViewPool pool, File data) {
        pool.setVisibility(R.id.common_item_arrow, data.isDirectory() ? 0 : 8).setText(R.id.common_item_title, data.getName()).setText(R.id.common_item_info, this.info);
    }

    @Override
    public int getLayout() {
        return R.layout.pd_item_common;
    }
}

