/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.util;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;

public class SensorDetector
implements SensorEventListener {
    private static long lastCheckTime;
    private static float[] lastXyz;
    private Callback callback;
    private Runnable task = new Runnable(){

        @Override
        public void run() {
            if (SensorDetector.this.callback != null) {
                SensorDetector.this.callback.shakeValid();
            }
        }
    };

    public SensorDetector(Callback callback) {
        this.register();
        this.callback = callback;
    }

    public void onSensorChanged(SensorEvent event) {
        if (Config.getSHAKE_SWITCH() && event.sensor.getType() == 1 && SensorDetector.checkIfShake(event.values[0], event.values[1], event.values[2])) {
            Utils.cancelTask(this.task);
            Utils.postDelayed(this.task, 150L);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void register() {
        try {
            SensorManager manager = (SensorManager)Utils.getContext().getSystemService("sensor");
            Sensor sensor = manager.getDefaultSensor(1);
            manager.registerListener((SensorEventListener)this, sensor, 3);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void unRegister() {
        try {
            SensorManager manager = (SensorManager)Utils.getContext().getSystemService("sensor");
            Sensor sensor = manager.getDefaultSensor(1);
            manager.unregisterListener((SensorEventListener)this, sensor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static boolean checkIfShake(float x, float y, float z) {
        long currentTime = System.currentTimeMillis();
        long diffTime = currentTime - lastCheckTime;
        if (diffTime < 100L) {
            return false;
        }
        lastCheckTime = currentTime;
        float deltaX = x - lastXyz[0];
        float deltaY = y - lastXyz[1];
        float deltaZ = z - lastXyz[2];
        SensorDetector.lastXyz[0] = x;
        SensorDetector.lastXyz[1] = y;
        SensorDetector.lastXyz[2] = z;
        int delta = (int)(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) / (double)diffTime * 10000.0);
        return delta > Config.getSHAKE_THRESHOLD();
    }

    static {
        lastXyz = new float[3];
    }

    public static interface Callback {
        public void shakeValid();
    }
}

