/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.support.v4.content.FileProvider;
import tech.linjiang.pandora.FuncController;
import tech.linjiang.pandora.crash.CrashHandler;
import tech.linjiang.pandora.database.Databases;
import tech.linjiang.pandora.function.IFunc;
import tech.linjiang.pandora.history.HistoryRecorder;
import tech.linjiang.pandora.inspector.attribute.AttrFactory;
import tech.linjiang.pandora.network.OkHttpInterceptor;
import tech.linjiang.pandora.preference.SharedPref;
import tech.linjiang.pandora.util.SensorDetector;
import tech.linjiang.pandora.util.Utils;

public final class Pandora
extends FileProvider
implements SensorDetector.Callback {
    private static Pandora INSTANCE;
    private OkHttpInterceptor interceptor;
    private Databases databases;
    private SharedPref sharedPref;
    private AttrFactory attrFactory;
    private CrashHandler crashHandler;
    private HistoryRecorder historyRecorder;
    private FuncController funcController;
    private SensorDetector sensorDetector;

    public Pandora() {
        if (INSTANCE != null) {
            throw new RuntimeException();
        }
    }

    public boolean onCreate() {
        INSTANCE = this;
        this.init((Application)this.getContext());
        return super.onCreate();
    }

    private void init(Application app) {
        Utils.init((Context)app);
        this.funcController = new FuncController(app);
        this.sensorDetector = new SensorDetector(this);
        this.interceptor = new OkHttpInterceptor();
        this.databases = new Databases();
        this.sharedPref = new SharedPref();
        this.attrFactory = new AttrFactory();
        this.crashHandler = new CrashHandler();
        this.historyRecorder = new HistoryRecorder(app);
    }

    public static Pandora get() {
        return INSTANCE;
    }

    public OkHttpInterceptor getInterceptor() {
        return this.interceptor;
    }

    public Databases getDatabases() {
        return this.databases;
    }

    public SharedPref getSharedPref() {
        return this.sharedPref;
    }

    public AttrFactory getAttrFactory() {
        return this.attrFactory;
    }

    public Activity getTopActivity() {
        return this.historyRecorder.getTopActivity();
    }

    public void addFunction(IFunc func) {
        this.funcController.addFunc(func);
    }

    public void open() {
        this.funcController.open();
    }

    public void close() {
        this.funcController.close();
    }

    public void disableShakeSwitch() {
        this.sensorDetector.unRegister();
    }

    @Override
    public void shakeValid() {
        this.open();
    }
}

