/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.ContentValues;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.database.DatabaseResult;
import tech.linjiang.pandora.ui.connector.EventCallback;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.item.KeyEditItem;
import tech.linjiang.pandora.ui.item.KeyValueItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class AddRowFragment
extends BaseListFragment {
    private int key;
    private String table;
    private EventCallback callback;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.key = this.getArguments().getInt("param1");
        this.table = this.getArguments().getString("param2");
        this.callback = (EventCallback)this.getArguments().getSerializable("param3");
        this.getArguments().remove("param3");
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Add Row");
        this.getToolbar().getMenu().findItem(R.id.menu_save).setVisible(true);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                List<BaseItem> datas = AddRowFragment.this.getAdapter().getItems();
                if (Utils.isNotEmpty(datas)) {
                    ContentValues values = new ContentValues();
                    for (int i = 0; i < datas.size(); ++i) {
                        if (!(datas.get(i) instanceof KeyEditItem) || !((KeyEditItem)datas.get((int)i)).editable) continue;
                        String[] data = (String[])((KeyEditItem)datas.get((int)i)).data;
                        values.put(data[0], data[1]);
                    }
                    if (values.size() > 0) {
                        AddRowFragment.this.insert(values);
                    }
                }
                return true;
            }
        });
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.closeSoftInput();
        this.callback = null;
    }

    @Override
    protected void onViewEnterAnimEnd(View container) {
        this.loadData();
    }

    private void loadData() {
        this.showLoading();
        new SimpleTask<Void, DatabaseResult>(new SimpleTask.Callback<Void, DatabaseResult>(){

            public DatabaseResult doInBackground(Void[] params) {
                return Pandora.get().getDatabases().getTableInfo(AddRowFragment.this.key, AddRowFragment.this.table);
            }

            @Override
            public void onPostExecute(DatabaseResult result) {
                ArrayList<BaseItem> data = new ArrayList<BaseItem>();
                if (result.sqlError == null) {
                    int i;
                    data.add(new TitleItem(String.format(Locale.getDefault(), "%d COLUMNS", result.values.size())));
                    data.add(new KeyValueItem(new String[]{"KEY", "VALUE"}, true));
                    HashMap<String, Integer> keyMapIndex = new HashMap<String, Integer>();
                    for (i = 0; i < result.columnNames.size(); ++i) {
                        if (TextUtils.equals((CharSequence)result.columnNames.get(i), (CharSequence)"name")) {
                            keyMapIndex.put("name", i);
                            continue;
                        }
                        if (TextUtils.equals((CharSequence)result.columnNames.get(i), (CharSequence)"type")) {
                            keyMapIndex.put("type", i);
                            continue;
                        }
                        if (TextUtils.equals((CharSequence)result.columnNames.get(i), (CharSequence)"notnull")) {
                            keyMapIndex.put("notnull", i);
                            continue;
                        }
                        if (TextUtils.equals((CharSequence)result.columnNames.get(i), (CharSequence)"dflt_value")) {
                            keyMapIndex.put("dflt_value", i);
                            continue;
                        }
                        if (!TextUtils.equals((CharSequence)result.columnNames.get(i), (CharSequence)"pk")) continue;
                        keyMapIndex.put("pk", i);
                    }
                    for (i = 0; i < result.values.size(); ++i) {
                        boolean isPrimaryKey = result.values.get(i).get((Integer)keyMapIndex.get("pk")).equals("1");
                        boolean isNotNull = result.values.get(i).get((Integer)keyMapIndex.get("notnull")).equals("1");
                        String typeName = result.values.get(i).get((Integer)keyMapIndex.get("type"));
                        boolean isInteger = "INTEGER".equalsIgnoreCase(typeName);
                        data.add(new KeyEditItem(isPrimaryKey && isInteger, new String[]{result.values.get(i).get((Integer)keyMapIndex.get("name")) + (isPrimaryKey ? "  (primaryKey)" : ""), isPrimaryKey && isInteger ? "AUTO" : result.values.get(i).get((Integer)keyMapIndex.get("dflt_value"))}, typeName + (isNotNull ? "" : "  (optional)")));
                    }
                    AddRowFragment.this.getAdapter().setItems(data);
                } else {
                    Utils.toast(result.sqlError.message);
                }
                AddRowFragment.this.hideLoading();
            }
        }).execute(new Void[0]);
    }

    private void insert(final ContentValues values) {
        this.showLoading();
        new SimpleTask<Void, DatabaseResult>(new SimpleTask.Callback<Void, DatabaseResult>(){

            public DatabaseResult doInBackground(Void[] params) {
                return Pandora.get().getDatabases().insert(AddRowFragment.this.key, AddRowFragment.this.table, values);
            }

            @Override
            public void onPostExecute(DatabaseResult result) {
                AddRowFragment.this.hideLoading();
                if (result.sqlError == null) {
                    Utils.toast(R.string.pd_success);
                    if (AddRowFragment.this.callback != null) {
                        AddRowFragment.this.callback.onComplete();
                    }
                } else {
                    Utils.toast(result.sqlError.message);
                }
            }
        }).execute(new Void[0]);
    }
}

