/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;
import tech.linjiang.pandora.util.ViewKnife;

abstract class HintView
extends View {
    private boolean firstHint = true;

    public HintView(Context context) {
        super(context);
    }

    protected String getViewHint() {
        return null;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.firstHint) {
            this.firstHint = false;
            String hintText = this.getViewHint();
            if (TextUtils.isEmpty((CharSequence)hintText)) {
                return;
            }
            hintText = "========\ud83c\udf7aTIPS\ud83c\udf7a========\n\n" + hintText + "\n\n===== Press back to exit =====";
            TextPaint textPaint = new TextPaint(1);
            textPaint.setColor(-1);
            textPaint.setTextSize((float)ViewKnife.dip2px(14.0f));
            textPaint.setTextAlign(Paint.Align.LEFT);
            textPaint.setFlags(32);
            StaticLayout layout2 = new StaticLayout((CharSequence)hintText, textPaint, canvas.getWidth() / 2, Layout.Alignment.ALIGN_NORMAL, 1.4f, 0.0f, false);
            canvas.save();
            canvas.translate((float)(canvas.getWidth() / 2 - layout2.getWidth() / 2), (float)(canvas.getHeight() / 2 - layout2.getHeight() / 2));
            canvas.save();
            int bgPadding = ViewKnife.dip2px(16.0f);
            canvas.translate((float)(-bgPadding), (float)(-bgPadding));
            RectF rect = new RectF();
            rect.set(0.0f, 0.0f, (float)(layout2.getWidth() + 2 * bgPadding), (float)(layout2.getHeight() + 2 * bgPadding));
            Paint paint = new Paint();
            paint.setColor(-2013265920);
            canvas.drawRoundRect(rect, (float)ViewKnife.dip2px(4.0f), (float)ViewKnife.dip2px(4.0f), paint);
            canvas.restore();
            layout2.draw(canvas);
            canvas.restore();
        }
    }
}

