/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import java.io.File;
import java.util.ArrayList;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.network.CacheDbHelper;
import tech.linjiang.pandora.network.model.Summary;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.NetContentFragment;
import tech.linjiang.pandora.ui.item.KeyValueItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.FileUtil;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class NetSummaryFragment
extends BaseListFragment {
    private Summary originData;

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        final long id2 = this.getArguments().getLong("param1");
        this.loadData(id2);
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (item instanceof KeyValueItem) {
                    String tag = (String)item.getTag();
                    if (!TextUtils.isEmpty((CharSequence)tag)) {
                        Bundle bundle = new Bundle();
                        if ("param1".equals(tag)) {
                            bundle.putBoolean("param1", false);
                            bundle.putString("param3", ((NetSummaryFragment)NetSummaryFragment.this).originData.request_content_type);
                        } else if ("param2".equals(tag)) {
                            if (((NetSummaryFragment)NetSummaryFragment.this).originData.response_content_type.contains("image")) {
                                NetSummaryFragment.this.tryOpen(((NetSummaryFragment)NetSummaryFragment.this).originData.id);
                                return;
                            }
                            bundle.putBoolean("param1", true);
                            bundle.putString("param3", ((NetSummaryFragment)NetSummaryFragment.this).originData.response_content_type);
                        }
                        if (!bundle.isEmpty()) {
                            bundle.putLong("param2", id2);
                            NetSummaryFragment.this.launch(NetContentFragment.class, bundle);
                        }
                    } else {
                        String value = ((String[])item.data)[1];
                        if (!TextUtils.isEmpty((CharSequence)value)) {
                            Utils.copy2ClipBoard(value);
                        }
                    }
                }
            }
        });
    }

    private void loadData(final long id2) {
        this.showLoading();
        new SimpleTask<Void, Summary>(new SimpleTask.Callback<Void, Summary>(){

            public Summary doInBackground(Void[] params) {
                return CacheDbHelper.getSummary(id2);
            }

            @Override
            public void onPostExecute(Summary summary) {
                NetSummaryFragment.this.hideLoading();
                if (summary == null) {
                    NetSummaryFragment.this.showError(null);
                    return;
                }
                NetSummaryFragment.this.originData = summary;
                NetSummaryFragment.this.getToolbar().setTitle((CharSequence)summary.url);
                NetSummaryFragment.this.getToolbar().setSubtitle((CharSequence)String.valueOf(summary.code));
                ArrayList<BaseItem> data = new ArrayList<BaseItem>();
                data.add(new TitleItem("GENERAL"));
                data.add(new KeyValueItem(Utils.newArray("url", summary.url)));
                data.add(new KeyValueItem(Utils.newArray("host", summary.host)));
                data.add(new KeyValueItem(Utils.newArray("method", summary.method)));
                data.add(new KeyValueItem(Utils.newArray("protocol", summary.protocol)));
                data.add(new KeyValueItem(Utils.newArray("ssl", String.valueOf(summary.ssl))));
                data.add(new KeyValueItem(Utils.newArray("start_time", Utils.millis2String(summary.start_time))));
                data.add(new KeyValueItem(Utils.newArray("end_time", Utils.millis2String(summary.end_time))));
                data.add(new KeyValueItem(Utils.newArray("req content-type", summary.request_content_type)));
                data.add(new KeyValueItem(Utils.newArray("res content-type", summary.response_content_type)));
                data.add(new KeyValueItem(Utils.newArray("request_size", Utils.formatSize(summary.request_size))));
                data.add(new KeyValueItem(Utils.newArray("response_size", Utils.formatSize(summary.response_size))));
                if (!TextUtils.isEmpty((CharSequence)summary.query)) {
                    data.add(new TitleItem(""));
                    data.add(new KeyValueItem(Utils.newArray("query", summary.query)));
                }
                data.add(new TitleItem("BODY"));
                KeyValueItem request = new KeyValueItem(Utils.newArray("request body", "tap to view"), false, true);
                request.setTag("param1");
                data.add(request);
                if (summary.status == 2) {
                    KeyValueItem response = new KeyValueItem(Utils.newArray("response body", "tap to view"), false, true);
                    response.setTag("param2");
                    data.add(response);
                }
                if (Utils.isNotEmpty(summary.request_header)) {
                    data.add(new TitleItem("REQUEST HEADER"));
                    for (Pair<String, String> pair : summary.request_header) {
                        data.add(new KeyValueItem(Utils.newArray((String)pair.first, (String)pair.second)));
                    }
                }
                if (Utils.isNotEmpty(summary.response_header)) {
                    data.add(new TitleItem("RESPONSE HEADER"));
                    for (Pair<String, String> pair : summary.response_header) {
                        data.add(new KeyValueItem(Utils.newArray((String)pair.first, (String)pair.second)));
                    }
                }
                NetSummaryFragment.this.getAdapter().setItems(data);
            }
        }).execute(new Void[0]);
    }

    private void tryOpen(final long id2) {
        new SimpleTask<Void, String>(new SimpleTask.Callback<Void, String>(){

            public String doInBackground(Void[] params) {
                return CacheDbHelper.getContent((long)id2).responseBody;
            }

            @Override
            public void onPostExecute(String result) {
                if (TextUtils.isEmpty((CharSequence)result)) {
                    Utils.toast(R.string.pd_failed);
                    return;
                }
                NetSummaryFragment.this.tryOpenInternal(result);
            }
        }).execute(new Void[0]);
    }

    private void tryOpenInternal(String path) {
        new SimpleTask<File, Intent>(new SimpleTask.Callback<File, Intent>(){

            public Intent doInBackground(File[] params) {
                String result = FileUtil.fileCopy2Tmp(params[0]);
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    return FileUtil.getFileIntent(result, "image/*");
                }
                return null;
            }

            @Override
            public void onPostExecute(Intent result) {
                NetSummaryFragment.this.hideLoading();
                if (result != null) {
                    try {
                        NetSummaryFragment.this.startActivity(result);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Utils.toast(t.getMessage());
                    }
                } else {
                    Utils.toast(R.string.pd_not_support);
                }
            }
        }).execute(new File[]{new File(path)});
        this.showLoading();
    }
}

