/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.recyclerview;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;

public class UniversalAdapter
extends RecyclerView.Adapter<ViewPool>
implements View.OnClickListener,
View.OnLongClickListener {
    private List<BaseItem> data = new ArrayList<BaseItem>();
    private OnItemClickListener listener;
    private OnItemLongClickListener longListener;

    public void setItems(List<? extends BaseItem> items) {
        this.data.clear();
        this.data.addAll(items);
        this.notifyDataSetChanged();
    }

    public void addItems(List<? extends BaseItem> items) {
        this.data.addAll(items);
        this.notifyDataSetChanged();
    }

    public void insertItems(List<? extends BaseItem> items, int index) {
        this.data.addAll(index, items);
        this.notifyDataSetChanged();
    }

    public void insertItem(BaseItem items, int index) {
        this.data.add(index, items);
        this.notifyDataSetChanged();
    }

    public void removeItem(int index) {
        this.data.remove(index);
        this.notifyItemRemoved(index);
    }

    public List<BaseItem> getItems() {
        return this.data;
    }

    public void clearItems() {
        this.data.clear();
        this.notifyDataSetChanged();
    }

    public void setListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public void setLongClickListener(OnItemLongClickListener longListener) {
        this.longListener = longListener;
    }

    public ViewPool onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(viewType, parent, false);
        view.setOnClickListener((View.OnClickListener)this);
        view.setOnLongClickListener((View.OnLongClickListener)this);
        return new ViewPool(view);
    }

    public void onBindViewHolder(ViewPool holder, int position) {
        holder.itemView.setTag(R.id.pd_recycler_adapter_id, (Object)position);
        this.data.get(position).onBinding(position, holder, this.data.get((int)position).data);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getItemViewType(int position) {
        return this.data.get(position).getLayout();
    }

    public void onClick(View v) {
        if (this.listener != null) {
            int position = (Integer)v.getTag(R.id.pd_recycler_adapter_id);
            this.listener.onItemClick(position, this.data.get(position));
        }
    }

    public boolean onLongClick(View v) {
        if (this.longListener != null) {
            int position = (Integer)v.getTag(R.id.pd_recycler_adapter_id);
            return this.longListener.onItemLongClick(position, this.data.get(position));
        }
        return false;
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(int var1, BaseItem var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, BaseItem var2);
    }

    public static final class ViewPool
    extends RecyclerView.ViewHolder {
        private final SparseArray<View> views = new SparseArray();

        public ViewPool(View itemView) {
            super(itemView);
        }

        public <T extends View> T getView(@IdRes int id2) {
            if (id2 == -1) {
                throw new RuntimeException("id is invalid");
            }
            View view = (View)this.views.get(id2);
            if (view == null) {
                view = this.itemView.findViewById(id2);
                this.views.put(id2, (Object)view);
            }
            return (T)view;
        }

        public ViewPool setText(@IdRes int id2, String text) {
            TextView tv = (TextView)this.getView(id2);
            tv.setText((CharSequence)text);
            return this;
        }

        public ViewPool setImageResource(@IdRes int id2, @DrawableRes int resId) {
            ImageView tv = (ImageView)this.getView(id2);
            tv.setImageResource(resId);
            return this;
        }

        public ViewPool setTextGravity(@IdRes int id2, int gravity) {
            TextView tv = (TextView)this.getView(id2);
            tv.setGravity(gravity);
            return this;
        }

        public ViewPool setVisibility(@IdRes int id2, int visibility) {
            Object v = this.getView(id2);
            v.setVisibility(visibility);
            return this;
        }

        public ViewPool setBackgroundColor(@IdRes int id2, @ColorInt int color2) {
            Object v = this.getView(id2);
            v.setBackgroundColor(color2);
            return this;
        }
    }
}

