/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.inspector.BaseLineView;
import tech.linjiang.pandora.inspector.OperableView;
import tech.linjiang.pandora.ui.connector.UIStateCallback;
import tech.linjiang.pandora.ui.fragment.NetFragment;
import tech.linjiang.pandora.ui.fragment.SandboxFragment;
import tech.linjiang.pandora.ui.fragment.ViewFragment;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class Dispatcher
extends AppCompatActivity
implements UIStateCallback {
    public static final String PARAM1 = "param1";
    private int type;
    private View hintView;

    public static void start(Context context, int type) {
        Intent intent = new Intent(context, Dispatcher.class).putExtra(PARAM1, type);
        if (Build.VERSION.SDK_INT < 24) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.type = this.getIntent().getIntExtra(PARAM1, 2);
        ViewKnife.setStatusBarColor(this.getWindow(), 0);
        ViewKnife.transStatusBar(this.getWindow());
        this.dispatch(savedInstanceState);
    }

    private void dispatch(Bundle savedInstanceState) {
        BaseLineView view = null;
        switch (this.type) {
            case 5: {
                view = new BaseLineView((Context)this);
                this.setContentView(view);
                break;
            }
            case 3: 
            case 7: {
                view = new FrameLayout((Context)this);
                view.setId(R.id.pd_fragment_container_id);
                this.setContentView(view);
                if (savedInstanceState != null) break;
                this.getSupportFragmentManager().beginTransaction().add(R.id.pd_fragment_container_id, (Fragment)ViewFragment.newInstance(this.type)).commit();
                break;
            }
            case 1: {
                view = new FrameLayout((Context)this);
                view.setId(R.id.pd_fragment_container_id);
                this.setContentView(view);
                if (savedInstanceState != null) break;
                this.getSupportFragmentManager().beginTransaction().add(R.id.pd_fragment_container_id, (Fragment)new NetFragment()).commit();
                break;
            }
            case 2: {
                view = new FrameLayout((Context)this);
                view.setId(R.id.pd_fragment_container_id);
                this.setContentView(view);
                if (savedInstanceState != null) break;
                this.getSupportFragmentManager().beginTransaction().add(R.id.pd_fragment_container_id, (Fragment)new SandboxFragment()).commit();
                break;
            }
            case 6: {
                OperableView operableView = new OperableView((Context)this);
                operableView.tryGetFrontView(Pandora.get().getBottomActivity());
                this.setContentView(operableView);
            }
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    protected void onStop() {
        super.onStop();
        if (!Utils.isNotEmpty(this.getSupportFragmentManager().getFragments())) {
            this.finish();
        }
    }

    @Override
    public void showHint() {
        if (this.hintView == null) {
            this.hintView = new ProgressBar((Context)this);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.gravity = 17;
            this.hintView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if (this.hintView.getParent() == null && this.getWindow() != null && this.getWindow().getDecorView() instanceof ViewGroup) {
            ((ViewGroup)this.getWindow().getDecorView()).addView(this.hintView);
        }
        if (this.hintView.getVisibility() == 8) {
            this.hintView.setVisibility(0);
        }
    }

    @Override
    public void hideHint() {
        if (this.hintView != null && this.hintView.getVisibility() != 8) {
            this.hintView.setVisibility(8);
        }
    }
}

