/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.treenode;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import java.util.List;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.inspector.treenode.Algorithm;
import tech.linjiang.pandora.inspector.treenode.ViewNode;
import tech.linjiang.pandora.util.ViewKnife;

public class TreeView
extends RelativeLayout {
    private static final String TAG = "TreeNodeView";
    private Paint linePaint = new Paint(){
        {
            this.setColor(-16776961);
            this.setStyle(Paint.Style.STROKE);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
        }
    };
    private ScaleGestureDetector scaleDetector;
    private GestureDetector gestureDetector;
    private Scroller scroller;
    private int touchSlop;
    private Algorithm algorithm;
    private ViewNode rootNode;
    private int nodeShadow = ViewKnife.dip2px(4.0f);
    private int nodeHeight = ViewKnife.dip2px(40.0f) + this.nodeShadow;
    private int nodeWidth = ViewKnife.dip2px(130.0f) + this.nodeShadow;
    private int nodeHorizontalMargin = ViewKnife.dip2px(16.0f);
    private int nodeVerticalMargin = ViewKnife.dip2px(32.0f);
    private float tmpCanvasLeft;
    private float tmpCanvasTop;
    private float tmpCanvasRight;
    private float tmpCanvasBottom;
    private Path tmpPath = new Path();
    private float[] tmpXy = new float[2];
    private Bitmap bitmapNodeCache;
    private float translateDx;
    private float translateDy;
    private float downX;
    private float downY;
    private float lastX;
    private float lastY;
    private boolean direction = false;
    private boolean isDragging;
    private boolean isScaling;
    private final float[] scaleData = new float[]{1.0f, 1.0f, 0.0f, 0.0f};
    private View.OnClickListener clickListener;
    private ScaleGestureDetector.SimpleOnScaleGestureListener listener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            ((TreeView)TreeView.this).scaleData[0] = detector.getScaleFactor() * TreeView.this.scaleData[0];
            float f = Math.max(0.3f, Math.min(TreeView.this.scaleData[0], 2.0f));
            ((TreeView)TreeView.this).scaleData[1] = f;
            ((TreeView)TreeView.this).scaleData[0] = f;
            TreeView.this.invalidate();
            return true;
        }
    };
    private GestureDetector.SimpleOnGestureListener gestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            TreeView.this.lastX = e2.getX();
            TreeView.this.lastY = e2.getY();
            TreeView.this.scroller.fling((int)e2.getX(), (int)e2.getY(), (int)velocityX, (int)velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            TreeView.this.invalidate();
            return true;
        }
    };
    private Paint debugPaint = new Paint(){
        {
            this.setStrokeWidth(ViewKnife.dip2px(4.0f));
            this.setStyle(Paint.Style.STROKE);
        }
    };
    private RectF tmpRectF = new RectF();

    public TreeView(Context context) {
        super(context);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.touchSlop = vc.getScaledTouchSlop();
        this.algorithm = new Algorithm(this.nodeHorizontalMargin, this.nodeVerticalMargin);
        this.setWillNotDraw(false);
        this.setBackgroundColor(-1);
        this.initChildButton();
        this.initBitmapCache();
        this.scaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this.listener);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.gestureListener);
        this.scroller = new Scroller(context);
    }

    private void initChildButton() {
        int padding = ViewKnife.dip2px(8.0f);
        ImageView toggle = new ImageView(this.getContext());
        toggle.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        toggle.setImageResource(R.drawable.pd_rotate);
        toggle.setPadding(padding, padding, padding, padding);
        RelativeLayout.LayoutParams toggleParam = new RelativeLayout.LayoutParams(ViewKnife.dip2px(50.0f), ViewKnife.dip2px(50.0f));
        toggleParam.addRule(12);
        toggleParam.addRule(11);
        this.addView((View)toggle, (ViewGroup.LayoutParams)toggleParam);
        toggle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TreeView.this.changeDirection();
            }
        });
        ImageView reset = new ImageView(this.getContext());
        reset.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        reset.setImageResource(R.drawable.pd_refresh);
        toggle.setPadding(padding, padding, padding, padding);
        RelativeLayout.LayoutParams resetParam = new RelativeLayout.LayoutParams(ViewKnife.dip2px(50.0f), ViewKnife.dip2px(50.0f));
        resetParam.addRule(12);
        resetParam.addRule(11);
        resetParam.rightMargin = ViewKnife.dip2px(50.0f);
        this.addView((View)reset, (ViewGroup.LayoutParams)resetParam);
        reset.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TreeView.this.resetInitPosition();
                TreeView.this.invalidate();
            }
        });
    }

    private void initBitmapCache() {
        Rect rect = new Rect(0, 0, this.nodeWidth - this.nodeShadow, this.nodeHeight - this.nodeShadow);
        this.bitmapNodeCache = Bitmap.createBitmap((int)this.nodeWidth, (int)this.nodeHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Paint paint = new Paint();
        paint.setColor(-12303292);
        paint.setMaskFilter((MaskFilter)new BlurMaskFilter((float)this.nodeShadow, BlurMaskFilter.Blur.OUTER));
        Canvas bitmapCanvas = new Canvas(this.bitmapNodeCache);
        bitmapCanvas.drawRect(rect, paint);
        paint.setColor(-1);
        paint.setMaskFilter(null);
        bitmapCanvas.drawRect(rect, paint);
        paint.setStrokeWidth((float)ViewKnife.dip2px(1.0f));
        paint.setColor(-12303292);
        paint.setStyle(Paint.Style.STROKE);
        bitmapCanvas.drawRect(rect, paint);
    }

    public void setRootView(View rootView) {
        this.rootNode = ViewNode.create(rootView, this.nodeWidth, this.nodeHeight);
        this.algorithm.calc(this.rootNode);
    }

    private void resetInitPosition() {
        this.scaleData[1] = 1.0f;
        this.scaleData[0] = 1.0f;
        this.scaleData[3] = 0.0f;
        this.scaleData[2] = 0.0f;
        if (this.direction) {
            this.translateDy = this.getCurVisualWidth() / 2 - this.nodeWidth / 2;
            this.translateDx = -this.getCurVisualHeight() / 4;
        } else {
            this.translateDx = this.getCurVisualWidth() / 2 - this.nodeWidth / 2;
            this.translateDy = this.getCurVisualHeight() / 4;
        }
    }

    private int getCurVisualWidth() {
        return this.direction ? this.getMeasuredHeight() : this.getMeasuredWidth();
    }

    private int getCurVisualHeight() {
        return this.direction ? this.getMeasuredWidth() : this.getMeasuredHeight();
    }

    private int getCurAxisX() {
        return (int)(this.direction ? this.translateDy : this.translateDx);
    }

    private int getCurAxisY() {
        return (int)(this.direction ? -this.translateDx : this.translateDy);
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.clickListener = l;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.gestureDetector.onTouchEvent(event);
        this.scaleDetector.onTouchEvent(event);
        switch (event.getActionMasked()) {
            case 0: {
                this.cancelAllAnim();
                this.downX = event.getX();
                this.downY = event.getY();
                return true;
            }
            case 5: {
                this.isScaling = true;
                this.lastX = event.getX(0);
                this.lastY = event.getY(0);
                break;
            }
            case 2: {
                if (this.isDragging) {
                    if (!this.isScaling) {
                        float dx = event.getX() - this.lastX;
                        float dy = event.getY() - this.lastY;
                        this.translateDx += dx;
                        this.translateDy += dy;
                        this.invalidate();
                    }
                } else {
                    float dy;
                    float dx = event.getX() - this.downX;
                    if (dx * dx + (dy = event.getY() - this.downY) * dy > (float)(this.touchSlop * this.touchSlop)) {
                        this.isDragging = true;
                    }
                }
                this.lastX = event.getX();
                this.lastY = event.getY();
                break;
            }
            case 6: {
                this.isScaling = false;
                int indexOfUpPointer = event.getActionIndex();
                if (indexOfUpPointer != 0) break;
                this.lastX = event.getX(1);
                this.lastY = event.getY(1);
                break;
            }
            case 1: 
            case 3: {
                if (!this.isDragging) {
                    this.handleClickEvent(event.getX(), event.getY());
                }
                this.isDragging = false;
                this.invalidate();
            }
        }
        return super.onTouchEvent(event);
    }

    private void cancelAllAnim() {
        this.scroller.abortAnimation();
    }

    public void computeScroll() {
        if (this.scroller.computeScrollOffset()) {
            int curX = this.scroller.getCurrX();
            int curY = this.scroller.getCurrY();
            this.translateDx += (float)curX - this.lastX;
            this.translateDy += (float)curY - this.lastY;
            this.lastX = curX;
            this.lastY = curY;
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.resetInitPosition();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        if (this.direction) {
            canvas.rotate(90.0f);
            canvas.translate(0.0f, (float)(-this.getCurVisualHeight()));
        }
        canvas.save();
        canvas.translate((float)this.getCurAxisX(), (float)this.getCurAxisY());
        canvas.save();
        canvas.scale(this.scaleData[0], this.scaleData[1], this.scaleData[2], this.scaleData[3]);
        this.drawInternal(canvas);
        canvas.restore();
        canvas.restore();
        canvas.restore();
    }

    private void drawInternal(Canvas canvas) {
        this.tmpCanvasLeft = (float)(-this.getCurAxisX()) / this.scaleData[0];
        this.tmpCanvasTop = (float)(-this.getCurAxisY()) / this.scaleData[0];
        this.tmpCanvasRight = (float)(-this.getCurAxisX() + this.getCurVisualWidth()) / this.scaleData[0];
        this.tmpCanvasBottom = (float)(-this.getCurAxisY() + this.getCurVisualHeight()) / this.scaleData[0];
        this.drawNode(canvas, this.rootNode);
        this.drawLines(canvas, this.rootNode);
    }

    private void drawNode(Canvas canvas, ViewNode viewNode) {
        if ((float)viewNode.getRect().right >= this.tmpCanvasLeft && (float)viewNode.getRect().bottom >= this.tmpCanvasTop && (float)viewNode.getRect().left <= this.tmpCanvasRight && (float)viewNode.getRect().top <= this.tmpCanvasBottom) {
            if (this.bitmapNodeCache != null && !this.bitmapNodeCache.isRecycled()) {
                canvas.drawBitmap(this.bitmapNodeCache, null, viewNode.getRect(), null);
            }
            canvas.save();
            canvas.translate((float)viewNode.getRect().left, (float)(viewNode.getRect().centerY() - viewNode.getLayout().getHeight() / 2));
            viewNode.getLayout().draw(canvas);
            canvas.restore();
        }
        if (viewNode.hasChildren()) {
            List<ViewNode> children = viewNode.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.drawNode(canvas, children.get(i));
            }
        }
    }

    private void drawLines(Canvas canvas, ViewNode treeNode) {
        if (treeNode.hasChildren()) {
            for (ViewNode child : treeNode.getChildren()) {
                this.drawLines(canvas, child);
            }
        }
        if (treeNode.hasParent()) {
            this.tmpPath.reset();
            int halfVMargin = this.nodeVerticalMargin >> 1;
            ViewNode parent = treeNode.getParent();
            this.tmpPath.moveTo((float)treeNode.getRect().centerX(), (float)treeNode.getRect().top);
            this.tmpPath.lineTo((float)treeNode.getRect().centerX(), (float)(treeNode.getRect().top - halfVMargin));
            this.tmpPath.lineTo((float)parent.getRect().centerX(), (float)(treeNode.getRect().top - halfVMargin));
            canvas.drawPath(this.tmpPath, this.linePaint);
            if ((float)parent.getRect().right >= this.tmpCanvasLeft && (float)parent.getRect().bottom >= this.tmpCanvasTop && (float)parent.getRect().left <= this.tmpCanvasRight && (float)parent.getRect().top <= this.tmpCanvasBottom) {
                this.tmpPath.reset();
                this.tmpPath.moveTo((float)parent.getRect().centerX(), (float)(treeNode.getRect().top - halfVMargin));
                this.tmpPath.lineTo((float)parent.getRect().centerX(), (float)parent.getRect().bottom);
                canvas.drawPath(this.tmpPath, this.linePaint);
            }
        }
    }

    private void handleClickEvent(float x, float y) {
        this.tmpXy[0] = x;
        this.tmpXy[1] = y;
        this.mapAxis(this.tmpXy);
        ViewNode node = this.findViewNode(this.rootNode, (int)this.tmpXy[0], (int)this.tmpXy[1]);
        if (node != null && this.clickListener != null) {
            this.clickListener.onClick(node.getView());
        }
    }

    private ViewNode findViewNode(ViewNode node, int x, int y) {
        if (node.getRect().contains(x, y)) {
            return node;
        }
        if (node.hasChildren()) {
            for (ViewNode viewNode : node.getChildren()) {
                ViewNode forNode = this.findViewNode(viewNode, x, y);
                if (forNode == null) continue;
                return forNode;
            }
        }
        return null;
    }

    private void mapAxis(float[] originXy) {
        float touchX = originXy[0];
        float touchY = originXy[1];
        if (this.direction) {
            float tmp = touchX;
            touchX = touchY;
            touchY = -tmp + (float)this.getCurVisualHeight();
        }
        touchX = (touchX - (float)this.getCurAxisX()) / this.scaleData[0];
        touchY = (touchY - (float)this.getCurAxisY()) / this.scaleData[0];
        originXy[0] = touchX;
        originXy[1] = touchY;
    }

    public void changeDirection() {
        this.direction = !this.direction;
        this.resetInitPosition();
        this.postInvalidate();
    }
}

