/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tech.linjiang.pandora.inspector.HintView;
import tech.linjiang.pandora.inspector.model.Element;

public class ElementHoldView
extends HintView {
    private static final String TAG = "ElementHoldView";
    private List<Element> elements = new ArrayList<Element>();

    public ElementHoldView(Context context) {
        super(context);
    }

    private void traverse(View view) {
        if (view.getAlpha() == 0.0f || view.getVisibility() != 0) {
            return;
        }
        this.elements.add(new Element(view));
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                this.traverse(parent.getChildAt(i));
            }
        }
    }

    protected final Element getTargetElement(float x, float y) {
        Element target = null;
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            Element element = this.elements.get(i);
            if (!element.getRect().contains((int)x, (int)y) || this.isParentNotVisible(element.getParentElement())) continue;
            target = element;
            break;
        }
        if (target == null) {
            Log.w((String)TAG, (String)"getTargetElement: not find");
        }
        return target;
    }

    protected final void resetAll() {
        for (Element e : this.elements) {
            if (e == null) continue;
            e.reset();
        }
    }

    private boolean isParentNotVisible(Element parent) {
        if (parent == null) {
            return false;
        }
        if (parent.getRect().left >= this.getMeasuredWidth() || parent.getRect().top >= this.getMeasuredHeight()) {
            return true;
        }
        return this.isParentNotVisible(parent.getParentElement());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.elements.clear();
    }

    public void tryGetFrontView(Activity targetActivity) {
        block5: {
            try {
                WindowManager windowManager = targetActivity.getWindowManager();
                Field mGlobalField = Class.forName("android.view.WindowManagerImpl").getDeclaredField("mGlobal");
                mGlobalField.setAccessible(true);
                if (Build.VERSION.SDK_INT <= 23) {
                    Field mViewsField = Class.forName("android.view.WindowManagerGlobal").getDeclaredField("mViews");
                    mViewsField.setAccessible(true);
                    List views = (List)mViewsField.get(mGlobalField.get(windowManager));
                    for (int i = views.size() - 1; i >= 0; --i) {
                        View targetView = this.getTargetDecorView(targetActivity, (View)views.get(i));
                        if (targetView == null) continue;
                        this.traverse(targetView);
                        break block5;
                    }
                    break block5;
                }
                Field mRootsField = Class.forName("android.view.WindowManagerGlobal").getDeclaredField("mRoots");
                mRootsField.setAccessible(true);
                List<Object> viewRootImpls = Build.VERSION.SDK_INT >= 19 ? (List<Object>)mRootsField.get(mGlobalField.get(windowManager)) : Arrays.asList((Object[])mRootsField.get(mGlobalField.get(windowManager)));
                for (int i = viewRootImpls.size() - 1; i >= 0; --i) {
                    Class<?> clazz = Class.forName("android.view.ViewRootImpl");
                    Object object = viewRootImpls.get(i);
                    Field mWindowAttributesField = clazz.getDeclaredField("mWindowAttributes");
                    mWindowAttributesField.setAccessible(true);
                    Field mViewField = clazz.getDeclaredField("mView");
                    mViewField.setAccessible(true);
                    View decorView = (View)mViewField.get(object);
                    WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)mWindowAttributesField.get(object);
                    if (!layoutParams.getTitle().toString().contains(targetActivity.getClass().getName()) && this.getTargetDecorView(targetActivity, decorView) == null) continue;
                    this.traverse(decorView);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.traverse(targetActivity.getWindow().peekDecorView());
            }
        }
    }

    private View getTargetDecorView(Activity targetActivity, View decorView) {
        View targetView = null;
        Context context = decorView.getContext();
        if (context == targetActivity) {
            targetView = decorView;
        } else {
            while (context instanceof ContextThemeWrapper) {
                Context baseContext = ((ContextThemeWrapper)context).getBaseContext();
                if (baseContext == targetActivity) {
                    targetView = decorView;
                    break;
                }
                context = baseContext;
            }
        }
        return targetView;
    }
}

