/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.appcompat.R;
import android.support.v7.widget.DialogTitle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.util.ViewKnife;

public class GeneralDialog
extends DialogFragment
implements DialogInterface.OnClickListener {
    public static final String ATTR1 = "ATTR1";
    public static final String ATTR2 = "ATTR2";
    public static final String ATTR3 = "ATTR3";
    public static final String ATTR4 = "ATTR4";
    public static final String ATTR5 = "ATTR5";
    public static final String ATTR6 = "ATTR6";
    public static final String ATTR7 = "ATTR7";
    private AlertDialog.Builder builder;
    private int code;

    public static Creator build(int code) {
        return new Creator(code);
    }

    public GeneralDialog() {
        if (this.getArguments() == null) {
            this.setArguments(new Bundle());
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        String positiveButton;
        String negativeButton;
        String message;
        super.onCreate(savedInstanceState);
        this.builder = new AlertDialog.Builder(this.getContext(), R.style.PdTheme_Alert);
        String title = this.getArguments().getString(ATTR2);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.builder.setTitle((CharSequence)title);
        }
        if (!TextUtils.isEmpty((CharSequence)(message = this.getArguments().getString(ATTR3)))) {
            this.builder.setMessage((CharSequence)message);
        }
        if (!TextUtils.isEmpty((CharSequence)(negativeButton = this.getArguments().getString(ATTR4)))) {
            this.builder.setNegativeButton((CharSequence)negativeButton, (DialogInterface.OnClickListener)this);
        }
        if (!TextUtils.isEmpty((CharSequence)(positiveButton = this.getArguments().getString(ATTR5)))) {
            this.builder.setPositiveButton((CharSequence)positiveButton, (DialogInterface.OnClickListener)this);
        }
        final boolean cancelable = this.getArguments().getBoolean(ATTR6, true);
        this.builder.setCancelable(cancelable);
        this.builder.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (event.getKeyCode() == 4) {
                    return !cancelable;
                }
                return false;
            }
        });
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                this.getParentFragment().onActivityResult(this.code, -1, null);
                break;
            }
            case -2: {
                this.getParentFragment().onActivityResult(this.code, 0, null);
            }
        }
    }

    @NonNull
    public final Dialog onCreateDialog(Bundle savedInstanceState) {
        this.code = this.getArguments().getInt(ATTR1);
        return this.builder.create();
    }

    @SuppressLint(value={"RestrictedApi"})
    public final void setupDialog(Dialog dialog, int style2) {
        super.setupDialog(dialog, style2);
        if (Build.VERSION.SDK_INT >= 21) {
            dialog.create();
            this.transform(dialog.getWindow());
        } else {
            dialog.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(DialogInterface dialog) {
                    GeneralDialog.this.transform(GeneralDialog.this.getDialog().getWindow());
                }
            });
        }
    }

    private void transform(Window window) {
        try {
            View sysContent = window.findViewById(0x1020002);
            GradientDrawable backgroundDrawable = new GradientDrawable();
            backgroundDrawable.setCornerRadius((float)ViewKnife.dip2px(10.0f));
            backgroundDrawable.setColor(-1);
            ViewCompat.setBackground((View)sysContent, (Drawable)backgroundDrawable);
            DialogTitle title = (DialogTitle)window.findViewById(R.id.alertTitle);
            TextView message = (TextView)window.findViewById(16908299);
            Button button1 = (Button)window.findViewById(16908313);
            Button button2 = (Button)window.findViewById(16908314);
            Button button3 = (Button)window.findViewById(16908315);
            LinearLayout buttonParent = (LinearLayout)button1.getParent();
            buttonParent.setShowDividers(2);
            GradientDrawable verticalDrawable = new GradientDrawable();
            verticalDrawable.setColor(-1710619);
            verticalDrawable.setSize(ViewKnife.dip2px(0.5f), 0);
            buttonParent.setDividerDrawable((Drawable)verticalDrawable);
            buttonParent.setPadding(0, 0, 0, 0);
            GradientDrawable innerDrawable = new GradientDrawable();
            innerDrawable.setStroke(ViewKnife.dip2px(0.5f), -1710619);
            InsetDrawable insetDrawable = new InsetDrawable((Drawable)innerDrawable, ViewKnife.dip2px(-1.0f), 0, ViewKnife.dip2px(-1.0f), ViewKnife.dip2px(-1.0f));
            ViewCompat.setBackground((View)buttonParent, (Drawable)insetDrawable);
            window.findViewById(R.id.spacer).setVisibility(8);
            View textSpacerNoButtons = window.findViewById(R.id.textSpacerNoButtons);
            if (textSpacerNoButtons != null) {
                textSpacerNoButtons.setVisibility(0);
            }
            button1.setTextColor(-10785903);
            button2.setTextColor(-13290187);
            button3.setTextColor(-13290187);
            button1.setPaintFlags(32);
            button2.setPaintFlags(32);
            button3.setPaintFlags(32);
            ((LinearLayout.LayoutParams)button3.getLayoutParams()).weight = 1.0f;
            ((LinearLayout.LayoutParams)button2.getLayoutParams()).weight = 1.0f;
            ((LinearLayout.LayoutParams)button1.getLayoutParams()).weight = 1.0f;
            if (message != null) {
                message.setTextColor(-14671840);
                if (this.getArguments().getBoolean(ATTR7, false)) {
                    if (Build.VERSION.SDK_INT >= 17) {
                        message.setTextAlignment(4);
                    } else {
                        message.setGravity(1);
                    }
                }
            }
            title.setTextColor(-13290187);
            title.setPaintFlags(32);
            if (Build.VERSION.SDK_INT >= 17) {
                title.setTextAlignment(4);
            } else {
                title.setGravity(1);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class Creator {
        Bundle bundle = new Bundle();

        Creator(int code) {
            this.bundle.putInt(GeneralDialog.ATTR1, code);
        }

        public Creator title(int res) {
            this.bundle.putString(GeneralDialog.ATTR2, ViewKnife.getString(res));
            return this;
        }

        public Creator message(int res) {
            this.message(res, false);
            return this;
        }

        public Creator message(int res, Object ... param) {
            this.bundle.putString(GeneralDialog.ATTR3, String.format(ViewKnife.getString(res), param));
            return this;
        }

        public Creator message(int res, boolean center) {
            this.bundle.putString(GeneralDialog.ATTR3, ViewKnife.getString(res));
            this.bundle.putBoolean(GeneralDialog.ATTR7, center);
            return this;
        }

        public Creator negativeButton(int res) {
            this.bundle.putString(GeneralDialog.ATTR4, ViewKnife.getString(res));
            return this;
        }

        public Creator positiveButton(int res) {
            this.bundle.putString(GeneralDialog.ATTR5, ViewKnife.getString(res));
            return this;
        }

        public Creator cancelable(boolean value) {
            this.bundle.putBoolean(GeneralDialog.ATTR6, value);
            return this;
        }

        public void show(Fragment fragment) {
            GeneralDialog dialog = new GeneralDialog();
            dialog.setArguments(this.bundle);
            dialog.show(fragment.getChildFragmentManager(), "GeneralDialog#" + this.bundle.getInt(GeneralDialog.ATTR1));
        }
    }
}

