/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.inspector.model.Element;
import tech.linjiang.pandora.util.ViewKnife;

public class ElementHoldView
extends View {
    private static final String TAG = "ElementHoldView";
    private List<Element> elements = new ArrayList<Element>();

    public ElementHoldView(Context context) {
        super(context);
    }

    private void traverse(View view) {
        if (view.getAlpha() == 0.0f || view.getVisibility() != 0) {
            return;
        }
        this.elements.add(new Element(view));
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                this.traverse(parent.getChildAt(i));
            }
        }
    }

    protected final Element getTargetElement(float x, float y) {
        Element target = null;
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            Element element = this.elements.get(i);
            if (!element.getRect().contains((int)x, (int)y) || this.isParentNotVisible(element.getParentElement())) continue;
            target = element;
            break;
        }
        if (target == null) {
            Log.w((String)TAG, (String)"getTargetElement: not find");
        }
        return target;
    }

    protected final Element getTargetElement(View v) {
        Element target = null;
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            Element element = this.elements.get(i);
            if (element.getView() != v) continue;
            target = element;
            break;
        }
        if (target == null) {
            Log.w((String)TAG, (String)"getTargetElement: not find");
        }
        return target;
    }

    protected final void resetAll() {
        for (Element e : this.elements) {
            if (e == null) continue;
            e.reset();
        }
    }

    private boolean isParentNotVisible(Element parent) {
        if (parent == null) {
            return false;
        }
        if (parent.getRect().left >= this.getMeasuredWidth() || parent.getRect().top >= this.getMeasuredHeight()) {
            return true;
        }
        return this.isParentNotVisible(parent.getParentElement());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.elements.clear();
    }

    public void tryGetFrontView(Activity targetActivity) {
        View decor = ViewKnife.tryGetTheFrontView(targetActivity);
        if (decor != null) {
            this.traverse(decor);
        }
    }
}

