/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import tech.linjiang.pandora.cache.Crash;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.GeneralDialog;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.CrashStackFragment;
import tech.linjiang.pandora.ui.item.CrashItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class CrashFragment
extends BaseListFragment {
    private final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());

    @Override
    protected boolean enableSwipeBack() {
        return false;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle(R.string.pd_name_crash);
        this.getToolbar().getMenu().add(-1, 0, 0, R.string.pd_name_delete_key).setIcon(R.drawable.pd_delete).setShowAsAction(2);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                GeneralDialog.build(1).title(R.string.pd_help_title).message(R.string.pd_make_sure, true).positiveButton(R.string.pd_ok).negativeButton(R.string.pd_cancel).show(CrashFragment.this);
                return true;
            }
        });
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (item instanceof CrashItem) {
                    Bundle bundle = new Bundle();
                    bundle.putSerializable("param1", (Serializable)((CrashItem)item).data);
                    CrashFragment.this.launch(CrashStackFragment.class, bundle);
                }
            }
        });
        this.loadData();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            Crash.clear();
            this.getAdapter().clearItems();
            Utils.toast(R.string.pd_success);
        }
    }

    private void loadData() {
        this.hideError();
        this.showLoading();
        new SimpleTask<Void, List<Crash>>(new SimpleTask.Callback<Void, List<Crash>>(){

            public List<Crash> doInBackground(Void[] params) {
                return Crash.query();
            }

            @Override
            public void onPostExecute(List<Crash> result) {
                CrashFragment.this.hideLoading();
                ArrayList<BaseItem> data = new ArrayList<BaseItem>(result.size());
                if (Utils.isNotEmpty(result)) {
                    String title = null;
                    for (Crash crash : result) {
                        String tmp = Utils.millis2String(crash.createTime, CrashFragment.this.FORMAT);
                        if (!TextUtils.equals(title, (CharSequence)tmp)) {
                            data.add(new TitleItem(tmp));
                            title = tmp;
                        }
                        data.add(new CrashItem(crash));
                    }
                    CrashFragment.this.getAdapter().setItems(data);
                } else {
                    CrashFragment.this.showError(null);
                }
            }
        }).execute(new Void[0]);
    }
}

