/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Toast;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import tech.linjiang.pandora.inspector.ElementHoldView;
import tech.linjiang.pandora.inspector.canvas.ClickInfoCanvas;
import tech.linjiang.pandora.inspector.canvas.GridCanvas;
import tech.linjiang.pandora.inspector.canvas.RelativeCanvas;
import tech.linjiang.pandora.inspector.canvas.SelectCanvas;
import tech.linjiang.pandora.inspector.model.Element;
import tech.linjiang.pandora.util.ViewKnife;

public class OperableView
extends ElementHoldView {
    private static final String TAG = "OperableView";
    private int searchCount = 0;
    private final int elementsNum = 2;
    private Element[] relativeElements = new Element[2];
    private Element targetElement;
    private SelectCanvas selectCanvas;
    private RelativeCanvas relativeCanvas;
    private GridCanvas gridCanvas;
    private ClickInfoCanvas clickInfoCanvas;
    private int touchSlop;
    private long longPressTimeout;
    private long tapTimeout;
    private float lastX;
    private float lastY;
    private float downX;
    private float downY;
    private int state;
    private float alpha;
    private ValueAnimator gridAnimator;
    private final Paint defPaint = new Paint(1){
        {
            this.setColor(-256);
            this.setStrokeWidth(ViewKnife.dip2px(2.0f));
            this.setStyle(Paint.Style.STROKE);
        }
    };
    private Runnable longPressCheck = new Runnable(){

        @Override
        public void run() {
            OperableView.this.state = 3;
            OperableView.this.alpha = 1.0f;
        }
    };
    private Runnable tapTimeoutCheck = new Runnable(){

        @Override
        public void run() {
            OperableView.this.state = 1;
            OperableView.this.gridAnimator = ObjectAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(OperableView.this.longPressTimeout - OperableView.this.tapTimeout);
            OperableView.this.gridAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    OperableView.this.alpha = value;
                    OperableView.this.invalidate();
                }
            });
            OperableView.this.gridAnimator.start();
        }
    };
    private View.OnClickListener clickListener;

    public OperableView(Context context) {
        super(context);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.touchSlop = vc.getScaledTouchSlop();
        this.longPressTimeout = ViewConfiguration.getLongPressTimeout();
        this.tapTimeout = ViewConfiguration.getTapTimeout();
        this.selectCanvas = new SelectCanvas(this);
        this.relativeCanvas = new RelativeCanvas(this);
        this.gridCanvas = new GridCanvas(this);
        this.clickInfoCanvas = new ClickInfoCanvas(this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.downX = this.lastX = event.getX();
                this.downY = this.lastY = event.getY();
                this.tryStartCheckTask();
                return true;
            }
            case 2: {
                float dy;
                float dx;
                if (this.state == 3) {
                    if (this.targetElement != null) {
                        float dx2 = event.getX() - this.lastX;
                        float dy2 = event.getY() - this.lastY;
                        this.targetElement.offset(dx2, dy2);
                        for (Element e : this.relativeElements) {
                            if (e == null) continue;
                            e.reset();
                        }
                        this.invalidate();
                    }
                } else if (this.state != 2 && (dx = event.getX() - this.downX) * dx + (dy = event.getY() - this.downY) * dy > (float)(this.touchSlop * this.touchSlop)) {
                    if (this.state == 1) {
                        Toast.makeText((Context)this.getContext(), (CharSequence)"CANCEL", (int)0).show();
                    }
                    this.state = 2;
                    this.cancelCheckTask();
                    this.invalidate();
                    Log.w((String)TAG, (String)"onTouchEvent: change to State.TOUCHING");
                }
                this.lastX = event.getX();
                this.lastY = event.getY();
                break;
            }
            case 1: 
            case 3: {
                this.cancelCheckTask();
                if (this.state == 0) {
                    this.handleClick(event.getX(), event.getY());
                } else if (this.state == 3) {
                    this.resetAll();
                }
                this.state = 0;
                this.invalidate();
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), this.defPaint);
        if (this.state == 3) {
            this.gridCanvas.draw(canvas, 1.0f);
        } else if (this.state == 1) {
            this.gridCanvas.draw(canvas, this.alpha);
        }
        this.selectCanvas.draw(canvas, this.relativeElements);
        this.relativeCanvas.draw(canvas, this.relativeElements[this.searchCount % 2], this.relativeElements[Math.abs(this.searchCount - 1) % 2]);
        this.clickInfoCanvas.draw(canvas);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelCheckTask();
        this.relativeElements = null;
    }

    private void cancelCheckTask() {
        this.removeCallbacks(this.longPressCheck);
        this.removeCallbacks(this.tapTimeoutCheck);
        if (this.gridAnimator != null) {
            this.gridAnimator.cancel();
            this.gridAnimator = null;
        }
    }

    private void tryStartCheckTask() {
        this.cancelCheckTask();
        if (this.targetElement != null) {
            this.postDelayed(this.longPressCheck, this.longPressTimeout);
            this.postDelayed(this.tapTimeoutCheck, this.tapTimeout);
        }
    }

    private void handleClick(float x, float y) {
        Element element = this.getTargetElement(x, y);
        this.handleElementSelected(element, true);
    }

    public boolean handleClick(View v) {
        Element element = this.getTargetElement(v);
        this.handleElementSelected(element, false);
        this.invalidate();
        return element != null;
    }

    private void handleElementSelected(Element element, boolean cancelIfSelected) {
        this.targetElement = element;
        if (element != null) {
            boolean bothNull = true;
            for (int i = 0; i < this.relativeElements.length; ++i) {
                if (this.relativeElements[i] == null) continue;
                if (this.relativeElements[i] == element) {
                    if (cancelIfSelected) {
                        this.relativeElements[i] = null;
                        this.searchCount = i;
                    }
                    if (this.clickListener != null) {
                        this.clickListener.onClick(element.getView());
                    }
                    return;
                }
                bothNull = false;
            }
            if (bothNull) {
                this.clickInfoCanvas.setInfoElement(element);
            }
            this.relativeElements[this.searchCount % 2] = element;
            ++this.searchCount;
            if (this.clickListener != null) {
                this.clickListener.onClick(element.getView());
            }
        }
    }

    public boolean isSelectedEmpty() {
        boolean empty = true;
        for (int i = 0; i < 2; ++i) {
            if (this.relativeElements[i] == null) continue;
            empty = false;
            break;
        }
        return empty;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.clickListener = l;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
        public static final int NONE = 0;
        public static final int PRESSING = 1;
        public static final int TOUCHING = 2;
        public static final int DRAGGING = 3;
    }
}

