/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.database;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import tech.linjiang.pandora.database.DatabaseDescriptor;
import tech.linjiang.pandora.database.DatabaseResult;
import tech.linjiang.pandora.database.protocol.IDriver;
import tech.linjiang.pandora.database.protocol.IProvider;

public class DatabaseDriver
implements IDriver<DatabaseDescriptor> {
    private static final String[] EXTRA_FILE_SUFFIXES = new String[]{"-journal", "-shm", "-uid", "-wal"};
    private final IProvider mProvider;

    public DatabaseDriver(IProvider mProvider) {
        this.mProvider = mProvider;
    }

    @Override
    public List<DatabaseDescriptor> getDatabaseNames() {
        ArrayList<DatabaseDescriptor> databases = new ArrayList<DatabaseDescriptor>();
        List<File> potentialDatabaseFiles = this.mProvider.getDatabaseFiles();
        Collections.sort(potentialDatabaseFiles);
        List<File> tidiedList = DatabaseDriver.tidyDatabaseList(potentialDatabaseFiles);
        for (File database : tidiedList) {
            databases.add(new DatabaseDescriptor(database));
        }
        return databases;
    }

    private static List<File> tidyDatabaseList(List<File> databaseFiles) {
        HashSet<File> originalAsSet = new HashSet<File>(databaseFiles);
        ArrayList<File> tidiedList = new ArrayList<File>();
        for (File databaseFile : databaseFiles) {
            String databaseFilename = databaseFile.getPath();
            String sansSuffix = DatabaseDriver.removeSuffix(databaseFilename, EXTRA_FILE_SUFFIXES);
            if (!sansSuffix.equals(databaseFilename) && originalAsSet.contains(new File(sansSuffix))) continue;
            tidiedList.add(databaseFile);
        }
        return tidiedList;
    }

    private static String removeSuffix(String str, String[] suffixesToRemove) {
        for (String suffix : suffixesToRemove) {
            if (!str.endsWith(suffix)) continue;
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTableNames(DatabaseDescriptor databaseDesc) throws SQLiteException {
        try (SQLiteDatabase database = this.openDatabase(databaseDesc);){
            ArrayList<String> arrayList;
            Cursor cursor = database.rawQuery("SELECT name FROM sqlite_master WHERE type IN (?/*, ?*/)", new String[]{"table"});
            try {
                ArrayList<String> tableNames = new ArrayList<String>();
                while (cursor.moveToNext()) {
                    tableNames.add(cursor.getString(0));
                }
                arrayList = tableNames;
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
            cursor.close();
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeSQL(DatabaseDescriptor databaseDesc, String query, DatabaseResult result) throws SQLiteException {
        try (SQLiteDatabase database = this.openDatabase(databaseDesc);){
            String firstWordUpperCase;
            switch (firstWordUpperCase = DatabaseDriver.getFirstWord(query).toUpperCase()) {
                case "UPDATE": 
                case "DELETE": {
                    this.executeUpdateDelete(database, query, result);
                    return;
                }
                case "INSERT": {
                    this.executeInsert(database, query, result);
                    return;
                }
                case "SELECT": 
                case "PRAGMA": 
                case "EXPLAIN": {
                    this.executeSelect(database, query, result);
                    return;
                }
                default: {
                    this.executeRawQuery(database, query, result);
                    return;
                }
            }
        }
    }

    private static String getFirstWord(String s) {
        int firstSpace = (s = s.trim()).indexOf(32);
        return firstSpace >= 0 ? s.substring(0, firstSpace) : s;
    }

    private void executeUpdateDelete(SQLiteDatabase database, String query, DatabaseResult result) {
        SQLiteStatement statement = database.compileStatement(query);
        int count = statement.executeUpdateDelete();
        result.transformUpdateDelete(count);
    }

    private void executeInsert(SQLiteDatabase database, String query, DatabaseResult result) {
        SQLiteStatement statement = database.compileStatement(query);
        long count = statement.executeInsert();
        result.transformInsert(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSelect(SQLiteDatabase database, String query, DatabaseResult result) {
        try (Cursor cursor = database.rawQuery(query, null);){
            result.transformSelect(cursor);
        }
    }

    private void executeRawQuery(SQLiteDatabase database, String query, DatabaseResult result) {
        database.execSQL(query);
        result.transformRawQuery();
    }

    private SQLiteDatabase openDatabase(DatabaseDescriptor databaseDesc) throws SQLiteException {
        return this.mProvider.openDatabase(databaseDesc.file);
    }
}

