/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.cache;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.cache.Content;
import tech.linjiang.pandora.cache.Crash;
import tech.linjiang.pandora.cache.History;
import tech.linjiang.pandora.cache.Summary;
import tech.linjiang.pandora.util.Utils;

class CacheDatabase
extends SQLiteOpenHelper {
    private static final String TAG = "CacheDatabase";
    private static final int DATABASE_VERSION = 1;
    private static final String DATABASE_NAME = "pandora.db";
    private static final List<Class> tables = new ArrayList<Class>();
    private static final CacheDatabase INSTANCE;

    private CacheDatabase() {
        super(Utils.getContext(), DATABASE_NAME, null, 1);
    }

    public void onCreate(SQLiteDatabase db) {
        for (Class table : tables) {
            db.execSQL(CacheDatabase.assembleCreateSQL(table));
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        for (Class table : tables) {
            db.execSQL("DROP TABLE IF EXISTS " + CacheDatabase.getTableName(table));
        }
        this.onCreate(db);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
    }

    private static SQLiteDatabase getWDb() {
        return INSTANCE.getWritableDatabase();
    }

    private static SQLiteDatabase getRDb() {
        return INSTANCE.getReadableDatabase();
    }

    private static String getTableName(Class<?> clazz) {
        return clazz.getAnnotation(Table.class).value();
    }

    private static String assembleCreateSQL(Class<?> clazz) {
        Field[] fields;
        StringBuilder sql = new StringBuilder();
        String preSql = "CREATE TABLE " + CacheDatabase.getTableName(clazz);
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            Column columnName = field.getAnnotation(Column.class);
            if (columnName == null) continue;
            if (columnName.primaryKey()) {
                preSql = preSql + " (" + columnName.value() + " INTEGER PRIMARY KEY";
                continue;
            }
            sql.append(", ");
            sql.append(String.format("%s %s", columnName.value(), CacheDatabase.type2String(field.getType())));
        }
        sql.append(")");
        sql.insert(0, preSql);
        Log.i((String)TAG, (String)("assembleCreateSQL: " + sql));
        return sql.toString();
    }

    private static String type2String(Class<?> type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return "INTEGER";
        }
        if (type == Float.TYPE || type == Float.class) {
            return "REAL";
        }
        if (type == Double.TYPE || type == Double.class) {
            return "REAL";
        }
        if (type == Long.TYPE || type == Long.class) {
            return "INTEGER";
        }
        if (type == Short.TYPE || type == Short.class) {
            return "INTEGER";
        }
        if (type == byte[].class || type == Byte[].class) {
            return "BLOB";
        }
        return "TEXT";
    }

    static void delete(Class<?> clazz) {
        CacheDatabase.getWDb().delete(CacheDatabase.getTableName(clazz), null, null);
    }

    static void update(Object obj) {
        Field[] fields;
        ContentValues values = new ContentValues();
        String[] primaryKey = new String[2];
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Column columnName = field.getAnnotation(Column.class);
            if (columnName == null) continue;
            if (columnName.primaryKey()) {
                try {
                    primaryKey[0] = columnName.value();
                    primaryKey[1] = String.valueOf(field.get(obj));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                continue;
            }
            try {
                if (field.get(obj) == null) continue;
                if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                    values.put(columnName.value(), Integer.valueOf(field.getInt(obj)));
                    continue;
                }
                if (field.getType() == Float.TYPE || field.getType() == Float.class) {
                    values.put(columnName.value(), Float.valueOf(field.getFloat(obj)));
                    continue;
                }
                if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                    values.put(columnName.value(), Double.valueOf(field.getDouble(obj)));
                    continue;
                }
                if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                    values.put(columnName.value(), Long.valueOf(field.getLong(obj)));
                    continue;
                }
                if (field.getType() == Short.TYPE || field.getType() == Short.class) {
                    values.put(columnName.value(), Short.valueOf(field.getShort(obj)));
                    continue;
                }
                if (field.getType() == byte[].class || field.getType() == Byte[].class) {
                    values.put(columnName.value(), (byte[])field.get(obj));
                    continue;
                }
                if (field.getType() != String.class) continue;
                values.put(columnName.value(), (String)field.get(obj));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            CacheDatabase.getWDb().updateWithOnConflict(CacheDatabase.getTableName(obj.getClass()), values, primaryKey[0] + " = ?", new String[]{primaryKey[1]}, 5);
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)"error when update: ", (Throwable)t);
        }
    }

    static long insert(Object obj) {
        Field[] fields;
        ContentValues values = new ContentValues();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Column columnName = field.getAnnotation(Column.class);
            if (columnName == null || columnName.primaryKey()) continue;
            try {
                if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                    values.put(columnName.value(), Integer.valueOf(field.getInt(obj)));
                    continue;
                }
                if (field.getType() == Float.TYPE || field.getType() == Float.class) {
                    values.put(columnName.value(), Float.valueOf(field.getFloat(obj)));
                    continue;
                }
                if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                    values.put(columnName.value(), Double.valueOf(field.getDouble(obj)));
                    continue;
                }
                if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                    values.put(columnName.value(), Long.valueOf(field.getLong(obj)));
                    continue;
                }
                if (field.getType() == Short.TYPE || field.getType() == Short.class) {
                    values.put(columnName.value(), Short.valueOf(field.getShort(obj)));
                    continue;
                }
                if (field.getType() == byte[].class || field.getType() == Byte[].class) {
                    values.put(columnName.value(), (byte[])field.get(obj));
                    continue;
                }
                if (field.getType() != String.class) continue;
                values.put(columnName.value(), (String)field.get(obj));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (values.size() > 0) {
            return CacheDatabase.getWDb().insertWithOnConflict(CacheDatabase.getTableName(obj.getClass()), null, values, 5);
        }
        return -1L;
    }

    static <T> List<T> queryList(Class<T> clazz, String condition, String suffix) {
        ArrayList<T> result = new ArrayList<T>();
        String sql = "select * from " + CacheDatabase.getTableName(clazz);
        if (!TextUtils.isEmpty((CharSequence)condition)) {
            sql = sql + " where " + condition;
        }
        if (!TextUtils.isEmpty((CharSequence)suffix)) {
            sql = sql + " " + suffix;
        }
        Log.i((String)TAG, (String)("queryList: " + sql));
        try {
            Cursor cursor = CacheDatabase.getRDb().rawQuery(sql, null);
            while (cursor.moveToNext()) {
                T obj = clazz.newInstance();
                CacheDatabase.assemble(obj, cursor);
                result.add(obj);
            }
            cursor.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    private static void assemble(Object obj, Cursor cursor) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Column columnName = field.getAnnotation(Column.class);
            if (columnName == null) continue;
            if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                int value = cursor.getInt(cursor.getColumnIndex(columnName.value()));
                field.set(obj, value);
                continue;
            }
            if (field.getType() == Float.TYPE || field.getType() == Float.class) {
                float value = cursor.getFloat(cursor.getColumnIndex(columnName.value()));
                field.set(obj, Float.valueOf(value));
                continue;
            }
            if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                double value = cursor.getDouble(cursor.getColumnIndex(columnName.value()));
                field.set(obj, value);
                continue;
            }
            if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                long value = cursor.getLong(cursor.getColumnIndex(columnName.value()));
                field.set(obj, value);
                continue;
            }
            if (field.getType() == Short.TYPE || field.getType() == Short.class) {
                short value = cursor.getShort(cursor.getColumnIndex(columnName.value()));
                field.set(obj, value);
                continue;
            }
            if (field.getType() == byte[].class || field.getType() == Byte[].class) {
                byte[] value = cursor.getBlob(cursor.getColumnIndex(columnName.value()));
                field.set(obj, value);
                continue;
            }
            if (field.getType() != String.class) continue;
            String value = cursor.getString(cursor.getColumnIndex(columnName.value()));
            field.set(obj, value);
        }
    }

    static {
        tables.add(Summary.class);
        tables.add(Content.class);
        tables.add(Crash.class);
        tables.add(History.class);
        INSTANCE = new CacheDatabase();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Table {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Column {
        public String value();

        public boolean primaryKey() default false;
    }
}

