/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.util;

import android.text.TextUtils;
import android.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import okhttp3.Headers;
import org.json.JSONArray;
import org.json.JSONException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FormatUtil {
    public static String formatHeaders(Headers headers) {
        JSONArray array = new JSONArray();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            array.put((Object)new JSONArray().put((Object)headers.name(i)).put((Object)headers.value(i)));
        }
        if (array.length() > 0) {
            return array.toString();
        }
        return null;
    }

    public static List<Pair<String, String>> parseHeaders(String headers) {
        ArrayList<Pair<String, String>> headerList = new ArrayList<Pair<String, String>>();
        if (!TextUtils.isEmpty((CharSequence)headers)) {
            try {
                JSONArray array = new JSONArray(headers);
                for (int i = 0; i < array.length(); ++i) {
                    Pair header = new Pair((Object)array.getJSONArray(i).getString(0), (Object)array.getJSONArray(i).getString(1));
                    headerList.add((Pair<String, String>)header);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return headerList;
    }

    public static List<String> printJson(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        int tabNum = 0;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder jsonFormat = new StringBuilder();
        int length = json.length();
        char last = '\u0000';
        for (int i = 0; i < length; ++i) {
            char c = json.charAt(i);
            if (c == '{') {
                ++tabNum;
                jsonFormat.append(c);
                result.add(jsonFormat.toString());
                jsonFormat = new StringBuilder();
                jsonFormat.append(FormatUtil.addTab(tabNum));
            } else if (c == '}') {
                result.add(jsonFormat.toString());
                jsonFormat = new StringBuilder();
                jsonFormat.append(FormatUtil.addTab(--tabNum));
                jsonFormat.append(c);
            } else if (c == ',') {
                jsonFormat.append(c);
                result.add(jsonFormat.toString());
                jsonFormat = new StringBuilder();
                jsonFormat.append(FormatUtil.addTab(tabNum));
            } else if (c == ':') {
                jsonFormat.append(c).append(" ");
            } else if (c == '[') {
                ++tabNum;
                char next = json.charAt(i + 1);
                if (next == ']') {
                    jsonFormat.append(c);
                } else {
                    jsonFormat.append(c);
                    result.add(jsonFormat.toString());
                    jsonFormat = new StringBuilder();
                    jsonFormat.append(FormatUtil.addTab(tabNum));
                }
            } else if (c == ']') {
                --tabNum;
                if (last == '[') {
                    jsonFormat.append(c);
                } else {
                    result.add(jsonFormat.toString());
                    jsonFormat = new StringBuilder();
                    jsonFormat.append(FormatUtil.addTab(tabNum)).append(c);
                }
            } else {
                jsonFormat.append(c);
            }
            last = c;
        }
        result.add(jsonFormat.toString());
        return result;
    }

    private static String addTab(int tabNum) {
        StringBuilder sbTab = new StringBuilder();
        for (int i = 0; i < tabNum; ++i) {
            sbTab.append("        ");
        }
        return sbTab.toString();
    }

    public static List<String> printXml(String xml) {
        try {
            xml = FormatUtil.toPrettyString(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] split = xml.split("\n");
        return Arrays.asList(split);
    }

    private static String toPrettyString(String xml) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))));
            document.normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 8);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

