/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.SwitchCompat;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.widget.CompoundButton;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.network.CacheDbHelper;
import tech.linjiang.pandora.network.NetStateListener;
import tech.linjiang.pandora.network.model.Summary;
import tech.linjiang.pandora.ui.connector.SimpleOnActionExpandListener;
import tech.linjiang.pandora.ui.connector.SimpleOnQueryTextListener;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.NetSummaryFragment;
import tech.linjiang.pandora.ui.item.NetItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class NetFragment
extends BaseListFragment
implements Toolbar.OnMenuItemClickListener,
CompoundButton.OnCheckedChangeListener,
NetStateListener {
    private List<BaseItem> originData = new ArrayList<BaseItem>();
    private List<BaseItem> tmpFilter = new ArrayList<BaseItem>();

    @Override
    protected boolean enableSwipeBack() {
        return false;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Network");
        this.getToolbar().getMenu().findItem(R.id.menu_switch).setVisible(true);
        this.getToolbar().getMenu().findItem(R.id.menu_search).setVisible(true);
        this.getToolbar().getMenu().findItem(R.id.menu_clear).setVisible(true);
        this.setSearchView();
        this.getToolbar().setOnMenuItemClickListener((Toolbar.OnMenuItemClickListener)this);
        SwitchCompat switchCompat = (SwitchCompat)this.getToolbar().getMenu().findItem(R.id.menu_switch).getActionView();
        switchCompat.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        if (Config.isNetLogEnable()) {
            switchCompat.setChecked(true);
        } else {
            this.showOpenLogHint();
        }
        Pandora.get().getInterceptor().setListener(this);
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (item instanceof NetItem) {
                    Bundle bundle = new Bundle();
                    bundle.putLong("param1", ((Summary)item.data).id);
                    NetFragment.this.launch(NetSummaryFragment.class, bundle);
                }
            }
        });
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        Pandora.get().getInterceptor().removeListener();
    }

    private void loadData() {
        this.hideError();
        this.showLoading();
        new SimpleTask<Void, List<Summary>>(new SimpleTask.Callback<Void, List<Summary>>(){

            public List<Summary> doInBackground(Void[] params) {
                return CacheDbHelper.getSummaries();
            }

            @Override
            public void onPostExecute(List<Summary> result) {
                NetFragment.this.hideLoading();
                if (Utils.isNotEmpty(result)) {
                    ArrayList<NetItem> data = new ArrayList<NetItem>(result.size());
                    for (Summary summary : result) {
                        data.add(new NetItem(summary));
                    }
                    NetFragment.this.getAdapter().setItems(data);
                    NetFragment.this.originData.clear();
                    NetFragment.this.originData.addAll(NetFragment.this.getAdapter().getItems());
                } else {
                    NetFragment.this.showError(null);
                }
            }
        }).execute(new Void[0]);
    }

    private void clearData() {
        this.showLoading();
        new SimpleTask<Void, Void>(new SimpleTask.Callback<Void, Void>(){

            public Void doInBackground(Void[] params) {
                CacheDbHelper.deleteAll();
                return null;
            }

            @Override
            public void onPostExecute(Void result) {
                NetFragment.this.getAdapter().clearItems();
                NetFragment.this.hideLoading();
                NetFragment.this.showError(null);
            }
        }).execute(new Void[0]);
    }

    private void setSearchView() {
        MenuItem menuItem = this.getToolbar().getMenu().findItem(R.id.menu_search);
        SearchView searchView = (SearchView)menuItem.getActionView();
        searchView.setInputType(144);
        searchView.setQueryHint((CharSequence)ViewKnife.getString(R.string.pd_net_search_hint));
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)new SimpleOnQueryTextListener(){

            @Override
            public boolean onQueryTextChange(String newText) {
                NetFragment.this.filter(newText);
                return true;
            }

            @Override
            public boolean onQueryTextSubmit(String query) {
                NetFragment.this.closeSoftInput();
                NetFragment.this.filter(query);
                return true;
            }
        });
        SimpleOnActionExpandListener.bind(menuItem, new SimpleOnActionExpandListener(){

            @Override
            public boolean onMenuItemActionCollapse(MenuItem item) {
                NetFragment.this.loadData();
                return true;
            }
        });
    }

    public boolean onMenuItemClick(MenuItem item) {
        if (item.getItemId() == R.id.menu_clear) {
            if (!Config.isNetLogEnable()) {
                return false;
            }
            this.clearData();
        }
        this.closeSoftInput();
        return true;
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        Config.setNetLogEnable(isChecked);
        if (isChecked) {
            this.loadData();
        } else {
            this.showOpenLogHint();
        }
    }

    private void showOpenLogHint() {
        this.getAdapter().clearItems();
        this.showError(ViewKnife.getString(R.string.pd_please_open_net_log));
    }

    @Override
    public void onRequestStart(long id2) {
        this.refreshSingleData(true, id2);
    }

    @Override
    public void onRequestEnd(long id2) {
        this.refreshSingleData(false, id2);
    }

    private void filter(String condition) {
        this.tmpFilter.clear();
        if (TextUtils.isEmpty((CharSequence)condition)) {
            this.loadData();
            return;
        }
        if (Utils.isNotEmpty(this.originData)) {
            for (int i = this.originData.size() - 1; i >= 0; --i) {
                String url;
                if (!(this.originData.get(i) instanceof NetItem) || !(url = ((Summary)this.originData.get((int)i).data).url).contains(condition)) continue;
                this.tmpFilter.add(this.originData.get(i));
            }
            this.getAdapter().setItems(this.tmpFilter);
        }
    }

    private void refreshSingleData(final boolean isNew, final long id2) {
        new SimpleTask<Void, Summary>(new SimpleTask.Callback<Void, Summary>(){

            public Summary doInBackground(Void[] params) {
                return CacheDbHelper.getSummary(id2);
            }

            @Override
            public void onPostExecute(Summary result) {
                NetFragment.this.hideLoading();
                if (result == null) {
                    return;
                }
                if (!isNew) {
                    for (int i = 0; i < NetFragment.this.getAdapter().getItems().size(); ++i) {
                        if (!(NetFragment.this.getAdapter().getItems().get(i) instanceof NetItem) || ((Summary)NetFragment.this.getAdapter().getItems().get((int)i).data).id != result.id) continue;
                        NetFragment.this.getAdapter().getItems().get((int)i).data = result;
                        NetFragment.this.getAdapter().notifyDataSetChanged();
                        break;
                    }
                } else {
                    NetFragment.this.getAdapter().insertItem(new NetItem(result), 0);
                }
                NetFragment.this.originData.clear();
                NetFragment.this.originData.addAll(NetFragment.this.getAdapter().getItems());
            }
        }).execute(new Void[0]);
    }
}

