/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class GridLineView
extends View {
    private boolean isOpen;
    private static final GridLineView gridLineView = new GridLineView(Utils.getContext());
    private int LINE_INTERVAL;
    private Paint paint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(0x30000000);
            this.setStrokeWidth(1.0f);
        }
    };

    public GridLineView(Context context) {
        super(context);
    }

    private static GridLineView open() {
        GridLineView.gridLineView.LINE_INTERVAL = ViewKnife.dip2px(Config.getUI_GRID_INTERVAL());
        try {
            WindowManager windowManager = (WindowManager)Utils.getContext().getSystemService("window");
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = -1;
            params.height = -1;
            params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
            params.flags = 24;
            params.format = -3;
            windowManager.addView((View)gridLineView, (ViewGroup.LayoutParams)params);
            GridLineView.gridLineView.isOpen = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return gridLineView;
    }

    private static void close() {
        Utils.removeViewFromWindow(gridLineView);
        GridLineView.gridLineView.isOpen = false;
    }

    public static void toggle() {
        if (GridLineView.gridLineView.isOpen) {
            GridLineView.close();
        } else {
            GridLineView.open();
        }
    }

    public static void show() {
        gridLineView.setVisibility(0);
    }

    public static void hide() {
        gridLineView.setVisibility(8);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int startX = 0; startX < this.getMeasuredWidth(); startX += this.LINE_INTERVAL) {
            canvas.drawLine((float)startX, 0.0f, (float)startX, (float)this.getMeasuredHeight(), this.paint);
        }
        for (int startY = 0; startY < this.getMeasuredHeight(); startY += this.LINE_INTERVAL) {
            canvas.drawLine(0.0f, (float)startY, (float)this.getMeasuredWidth(), (float)startY, this.paint);
        }
    }
}

