/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.network;

import android.content.ContentValues;
import android.text.TextUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import tech.linjiang.pandora.network.CacheDbHelper;
import tech.linjiang.pandora.network.NetStateListener;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.JsonUtil;
import tech.linjiang.pandora.util.Utils;

public class OkHttpInterceptor
implements Interceptor {
    private static final String TAG = "OkHttpInterceptor";
    private NetStateListener listener;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        long delayReq;
        Connection connection = chain.connection();
        if (connection != null) {
            throw new IllegalStateException("should use addInterceptor instead of addNetworkInterceptor");
        }
        long id2 = -1L;
        Request request = chain.request();
        if (Config.getCOMMON_NETWORK_SWITCH() && Config.isNetLogEnable()) {
            id2 = this.insert(request);
            this.notifyStart(id2);
        }
        if ((delayReq = Config.getNETWORK_DELAY_REQ()) > 0L) {
            try {
                Thread.sleep(delayReq);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            response = chain.proceed(request);
        }
        catch (IOException e) {
            if (Config.getCOMMON_NETWORK_SWITCH() && Config.isNetLogEnable() && id2 >= 0L) {
                this.markFailed(id2);
                this.notifyEnd(id2);
            }
            throw e;
        }
        long delayRes = Config.getNETWORK_DELAY_RES();
        if (delayRes > 0L) {
            try {
                Thread.sleep(delayRes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (Config.getCOMMON_NETWORK_SWITCH() && Config.isNetLogEnable() && id2 >= 0L) {
            this.updateSummary(id2, response);
            this.updateContent(id2, response);
            this.notifyEnd(id2);
        }
        return response;
    }

    private long insert(Request request) {
        boolean canRecognize;
        RequestBody requestBody;
        ContentValues values = new ContentValues();
        ContentValues contentValues = new ContentValues();
        values.put("status", Integer.valueOf(0));
        values.put("url", request.url().encodedPath());
        values.put("host", request.url().host() + ":" + request.url().port());
        values.put("method", request.method());
        values.put("ssl", Boolean.valueOf(request.isHttps()));
        values.put("start_time", Long.valueOf(System.currentTimeMillis()));
        values.put("request_header", JsonUtil.formatHeaders(request.headers()));
        String query = request.url().encodedQuery();
        if (!TextUtils.isEmpty((CharSequence)query)) {
            values.put("query", query);
        }
        if ((requestBody = request.body()) != null) {
            try {
                values.put("request_size", Long.valueOf(requestBody.contentLength()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (canRecognize = this.checkContentEncoding(request.header("Content-Encoding"))) {
            contentValues.put("request", OkHttpInterceptor.requestBodyAsStr(request));
        }
        long id2 = CacheDbHelper.SummaryEntry.insert(values);
        contentValues.put("summary_id", Long.valueOf(id2));
        CacheDbHelper.ContentEntry.insert(contentValues);
        return id2;
    }

    private void updateSummary(long reqId, Response response) {
        ContentValues values = new ContentValues();
        values.put("status", Integer.valueOf(2));
        values.put("end_time", Long.valueOf(System.currentTimeMillis()));
        values.put("code", Integer.valueOf(response.code()));
        values.put("protocol", response.protocol().toString());
        values.put("response_header", JsonUtil.formatHeaders(response.headers()));
        ResponseBody body = response.body();
        if (body != null) {
            MediaType type = body.contentType();
            if (type != null) {
                values.put("response_content_type", type.toString());
            }
            values.put("response_size", Long.valueOf(body.contentLength()));
        }
        CacheDbHelper.SummaryEntry.update(reqId, values);
    }

    private void updateContent(long reqId, Response response) {
        boolean canRecognize = this.checkContentEncoding(response.header("Content-Encoding"));
        if (canRecognize) {
            ContentValues values = new ContentValues();
            values.put("response", OkHttpInterceptor.responseBodyAsStr(response));
            CacheDbHelper.ContentEntry.update(reqId, values);
        }
    }

    private void markFailed(long id2) {
        ContentValues values = new ContentValues();
        values.put("status", Integer.valueOf(1));
        values.put("end_time", Long.valueOf(System.currentTimeMillis()));
        CacheDbHelper.SummaryEntry.update(id2, values);
    }

    private void notifyStart(final long id2) {
        if (this.listener != null) {
            Utils.post(new Runnable(){

                @Override
                public void run() {
                    if (OkHttpInterceptor.this.listener != null) {
                        OkHttpInterceptor.this.listener.onRequestStart(id2);
                    }
                }
            });
        }
    }

    private void notifyEnd(final long id2) {
        if (this.listener != null) {
            Utils.post(new Runnable(){

                @Override
                public void run() {
                    if (OkHttpInterceptor.this.listener != null) {
                        OkHttpInterceptor.this.listener.onRequestEnd(id2);
                    }
                }
            });
        }
    }

    private boolean checkContentEncoding(String contentEncoding) {
        return contentEncoding == null || contentEncoding.equalsIgnoreCase("identity") || contentEncoding.equalsIgnoreCase("gzip");
    }

    private static String requestBodyAsStr(Request request) {
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            return null;
        }
        String contentEncoding = request.header("Content-Encoding");
        boolean gzip = "gzip".equalsIgnoreCase(contentEncoding);
        Buffer buffer = new Buffer();
        try {
            requestBody.writeTo((BufferedSink)buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return OkHttpInterceptor.sourceToStrInternal((Source)buffer, gzip, requestBody.contentType());
    }

    private static String responseBodyAsStr(Response response) {
        ResponseBody responseBody = response.body();
        if (responseBody == null || !HttpHeaders.hasBody((Response)response)) {
            return null;
        }
        String contentEncoding = response.header("Content-Encoding");
        boolean gzip = "gzip".equalsIgnoreCase(contentEncoding);
        try {
            return OkHttpInterceptor.sourceToStrInternal((Source)response.peekBody(Long.MAX_VALUE).source(), gzip, responseBody.contentType());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sourceToStrInternal(Source source, boolean gzip, MediaType contentType) {
        BufferedSource bufferedSource;
        if (gzip) {
            GzipSource gzipSource = new GzipSource(source);
            bufferedSource = Okio.buffer((Source)gzipSource);
        } else {
            bufferedSource = Okio.buffer((Source)source);
        }
        String tempStr = null;
        Charset charset = UTF8;
        if (contentType != null) {
            charset = contentType.charset(UTF8);
        }
        try {
            tempStr = bufferedSource.readString(charset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufferedSource.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempStr;
    }

    public void setListener(NetStateListener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }
}

