/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import tech.linjiang.pandora.database.Databases;
import tech.linjiang.pandora.inspector.CurInfoView;
import tech.linjiang.pandora.inspector.GridLineView;
import tech.linjiang.pandora.inspector.attribute.AttrFactory;
import tech.linjiang.pandora.network.OkHttpInterceptor;
import tech.linjiang.pandora.preference.SharedPref;
import tech.linjiang.pandora.ui.Dispatcher;
import tech.linjiang.pandora.ui.connector.OnEntranceClick;
import tech.linjiang.pandora.ui.connector.SimpleActivityLifecycleCallbacks;
import tech.linjiang.pandora.ui.view.EntranceView;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;

@SuppressLint(value={"StaticFieldLeak"})
public final class Pandora {
    private static Pandora INSTANCE;
    private final OkHttpInterceptor interceptor = new OkHttpInterceptor();
    private final Databases databases = new Databases();
    private final SharedPref sharedPref = new SharedPref();
    private final AttrFactory attrFactory = new AttrFactory();
    private Activity bottomActivity;
    private boolean preventFree;
    private final SimpleActivityLifecycleCallbacks callbacks = new SimpleActivityLifecycleCallbacks(){
        private int count;

        @Override
        public void onActivityStarted(Activity activity) {
            super.onActivityStarted(activity);
            ++this.count;
            if (this.count == 1) {
                Pandora.this.showOverlays();
            }
            if (activity instanceof Dispatcher) {
                EntranceView.hide();
            }
        }

        @Override
        public void onActivityResumed(Activity activity) {
            super.onActivityResumed(activity);
            if (!(activity instanceof Dispatcher)) {
                INSTANCE.bottomActivity = activity;
            }
            CurInfoView.updateText(activity.getClass().getName());
        }

        @Override
        public void onActivityPaused(Activity activity) {
            super.onActivityPaused(activity);
            if (activity == INSTANCE.bottomActivity && !INSTANCE.preventFree) {
                INSTANCE.bottomActivity = null;
            }
            CurInfoView.updateText(null);
        }

        @Override
        public void onActivityStopped(Activity activity) {
            super.onActivityStopped(activity);
            --this.count;
            if (this.count <= 0) {
                Pandora.this.hideOverlays();
            } else if (activity instanceof Dispatcher) {
                EntranceView.show();
            }
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
            super.onActivityDestroyed(activity);
            if (activity instanceof Dispatcher) {
                INSTANCE.preventFree = false;
            }
        }
    };
    private final SensorEventListener sensorEventListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent event) {
            if (Config.getSHAKE_SWITCH() && event.sensor.getType() == 1 && Utils.checkIfShake(event.values[0], event.values[1], event.values[2])) {
                Pandora.this.open();
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    static void init(Application application) {
        INSTANCE = new Pandora();
        Utils.init((Context)application);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)Pandora.INSTANCE.callbacks);
        application.registerComponentCallbacks(new ComponentCallbacks(){

            public void onConfigurationChanged(Configuration newConfig) {
            }

            public void onLowMemory() {
            }
        });
        Utils.registerSensor(Pandora.INSTANCE.sensorEventListener);
    }

    public static Pandora get() {
        return INSTANCE;
    }

    private Pandora() {
        EntranceView.setListener(new OnEntranceClick(){

            @Override
            protected void onClick(int type) {
                if (type == 8) {
                    GridLineView.toggle();
                    return;
                }
                if (type == 9) {
                    CurInfoView.toggle();
                    return;
                }
                Pandora.this.preventFree = true;
                super.onClick(type);
            }
        });
    }

    public OkHttpInterceptor getInterceptor() {
        return this.interceptor;
    }

    public Databases getDatabases() {
        return this.databases;
    }

    public SharedPref getSharedPref() {
        return this.sharedPref;
    }

    public AttrFactory getAttrFactory() {
        return this.attrFactory;
    }

    public Activity getBottomActivity() {
        return this.bottomActivity;
    }

    public void open() {
        if (Utils.checkPermission()) {
            EntranceView.open();
        }
    }

    private void showOverlays() {
        EntranceView.show();
        CurInfoView.show();
        GridLineView.show();
    }

    private void hideOverlays() {
        EntranceView.hide();
        CurInfoView.hide();
        GridLineView.hide();
    }
}

