/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.treenode;

import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.inspector.treenode.INode;
import tech.linjiang.pandora.util.ViewKnife;

public class ViewNode
implements INode {
    private int mWidth = 60;
    private int mHeight = 20;
    private int mLevel;
    private int mNodeCount = 1;
    private ViewNode mParent;
    private List<ViewNode> mChildren = new ArrayList<ViewNode>();
    private Rect rect = new Rect();
    private final View view;
    private final StaticLayout layout;
    private static TextPaint TEXT_PAINT = new TextPaint(){
        {
            this.setAntiAlias(true);
            this.setTextSize(ViewKnife.dip2px(9.0f));
            this.setColor(-16777216);
            this.setStyle(Paint.Style.FILL);
            this.setStrokeWidth(ViewKnife.dip2px(1.0f));
            this.setFlags(32);
        }
    };

    private ViewNode(View view, int width, int height) {
        this.view = view;
        this.mWidth = width;
        this.mHeight = height;
        this.layout = new StaticLayout((CharSequence)(view.getClass().getSimpleName() + "\n(" + ViewKnife.getIdString(view) + ")"), TEXT_PAINT, this.mWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
    }

    public static ViewNode create(View view, int width, int height) {
        ViewNode rootNode = new ViewNode(view, width, height);
        ViewNode.buildNode(rootNode, width, height);
        return rootNode;
    }

    private static void buildNode(ViewNode node, int width, int height) {
        ViewGroup group;
        View view = node.getView();
        if (view instanceof ViewGroup && (group = (ViewGroup)view).getChildCount() > 0) {
            for (int i = 0; i < group.getChildCount(); ++i) {
                ViewNode treeNode = new ViewNode(group.getChildAt(i), width, height);
                node.addChild(treeNode);
                ViewNode.buildNode(treeNode, width, height);
            }
        }
    }

    public int getLevel() {
        return this.mLevel;
    }

    public Rect getRect() {
        return this.rect;
    }

    @Override
    public void setLevel(int level) {
        this.mLevel = level;
    }

    @Override
    public void setX(int x) {
        this.rect.set(x, this.rect.top, x + this.mWidth, this.rect.bottom);
    }

    @Override
    public void setY(int y) {
        this.rect.set(this.rect.left, y, this.rect.right, y + this.mHeight);
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    public View getView() {
        return this.view;
    }

    public StaticLayout getLayout() {
        return this.layout;
    }

    private void notifyParentNodeCountChanged() {
        if (this.mParent != null) {
            this.mParent.notifyParentNodeCountChanged();
        } else {
            this.calculateNodeCount();
        }
    }

    private int calculateNodeCount() {
        int size = 1;
        for (ViewNode child : this.mChildren) {
            size += child.calculateNodeCount();
        }
        this.mNodeCount = size;
        return this.mNodeCount;
    }

    public void addChild(ViewNode child) {
        this.mChildren.add(child);
        child.mParent = this;
        this.notifyParentNodeCountChanged();
    }

    public int getNodeCount() {
        return this.mNodeCount;
    }

    @Override
    public ViewNode getParent() {
        return this.mParent;
    }

    public List<ViewNode> getChildren() {
        return this.mChildren;
    }

    public boolean hasChildren() {
        return !this.mChildren.isEmpty();
    }

    public boolean hasParent() {
        return this.mParent != null;
    }

    public boolean isFirstChild(ViewNode node) {
        return this.mChildren.indexOf(node) == 0;
    }
}

