/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.database.protocol.IProvider;

class DatabaseProvider
implements IProvider {
    private Context context;

    public DatabaseProvider(Context context) {
        this.context = context;
    }

    @Override
    public List<File> getDatabaseFiles() {
        ArrayList<File> databaseFiles = new ArrayList<File>();
        for (String databaseName : this.context.databaseList()) {
            databaseFiles.add(this.context.getDatabasePath(databaseName));
        }
        return databaseFiles;
    }

    @Override
    public SQLiteDatabase openDatabase(File databaseFile) throws SQLiteException {
        return this.performOpen(databaseFile, this.checkIfCanOpenWithWAL(databaseFile));
    }

    private int checkIfCanOpenWithWAL(File databaseFile) {
        File walFile;
        int flags = 0;
        if (Build.VERSION.SDK_INT >= 16 && (walFile = new File(databaseFile.getParent(), databaseFile.getName() + "-wal")).exists()) {
            flags |= 0x20000000;
        }
        return flags;
    }

    private SQLiteDatabase performOpen(File databaseFile, int options) {
        int flags = 0;
        if (Build.VERSION.SDK_INT >= 16 && (options & 0x20000000) != 0) {
            flags |= 0x20000000;
        }
        SQLiteDatabase db = SQLiteDatabase.openDatabase((String)databaseFile.getAbsolutePath(), null, (int)flags);
        return db;
    }
}

