/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.recyclerview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;

public class GridDividerDecoration
extends RecyclerView.ItemDecoration {
    private Paint mPaint;
    private int mThickness;
    private boolean needHorizontal;
    private boolean needVertical;
    private VisibilityProvider visibilityProvider;

    protected GridDividerDecoration(int thickness, @ColorInt int color2) {
        this.mThickness = thickness;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(color2);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int groupIndex;
        int childPosition;
        super.getItemOffsets(outRect, view, parent, state);
        int itemPosition = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        int spanCount = this.getSpanCount(parent);
        int childCount = parent.getAdapter().getItemCount();
        boolean isLastRow = this.isLastRow(parent, itemPosition, spanCount, childCount);
        boolean isLastColumn = this.isLastColumn(parent, itemPosition, spanCount, childCount);
        int eachWidth = (spanCount - 1) * this.mThickness / spanCount;
        int dl = this.mThickness - eachWidth;
        int left = itemPosition % spanCount * dl;
        int right = eachWidth - left;
        int bottom = this.mThickness;
        if (isLastRow) {
            bottom = 0;
        }
        if (!this.needVertical) {
            right = 0;
            left = 0;
        } else if (this.visibilityProvider != null && this.visibilityProvider.shouldHideDivider(childPosition = parent.getChildAdapterPosition(view), groupIndex = this.getGroupIndex(childPosition, parent))) {
            right = 0;
            left = 0;
        }
        bottom = this.needHorizontal ? bottom : 0;
        outRect.set(left, 0, right, bottom);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
        this.draw(c, parent);
    }

    private void draw(Canvas canvas, RecyclerView parent) {
        int childSize = parent.getChildCount();
        for (int i = 0; i < childSize; ++i) {
            int groupIndex;
            int childPosition;
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getLeft();
            int right = child.getRight();
            int top = child.getBottom() + layoutParams.bottomMargin;
            int bottom = top + this.mThickness;
            if (this.mPaint != null && this.needHorizontal) {
                canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
            }
            top = child.getTop();
            bottom = child.getBottom() + this.mThickness;
            left = child.getRight() + layoutParams.rightMargin;
            right = left + this.mThickness;
            if (this.mPaint == null || !this.needVertical || this.visibilityProvider != null && this.visibilityProvider.shouldHideDivider(childPosition = parent.getChildAdapterPosition(child), groupIndex = this.getGroupIndex(childPosition, parent))) continue;
            canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
        }
    }

    private boolean isLastColumn(RecyclerView parent, int pos, int spanCount, int childCount) {
        int orientation;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        return layoutManager instanceof GridLayoutManager ? (pos + 1) % spanCount == 0 : layoutManager instanceof StaggeredGridLayoutManager && ((orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation()) == 1 ? (pos + 1) % spanCount == 0 : pos >= (childCount -= childCount % spanCount));
    }

    private boolean isLastRow(RecyclerView parent, int pos, int spanCount, int childCount) {
        int orientation;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            int lines = childCount % spanCount == 0 ? childCount / spanCount : childCount / spanCount + 1;
            return lines == pos / spanCount + 1;
        }
        return layoutManager instanceof StaggeredGridLayoutManager && ((orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation()) == 1 ? pos >= (childCount -= childCount % spanCount) : (pos + 1) % spanCount == 0);
    }

    private int getSpanCount(RecyclerView parent) {
        int spanCount = -1;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            spanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        return spanCount;
    }

    private int getGroupIndex(int position, RecyclerView parent) {
        if (parent.getLayoutManager() instanceof GridLayoutManager) {
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            GridLayoutManager.SpanSizeLookup spanSizeLookup = layoutManager.getSpanSizeLookup();
            int spanCount = layoutManager.getSpanCount();
            return spanSizeLookup.getSpanGroupIndex(position, spanCount);
        }
        return position;
    }

    public static interface VisibilityProvider {
        public boolean shouldHideDivider(int var1, int var2);
    }

    public static class Builder {
        private int mThickness;
        private int color = 0;
        private boolean needHorizontal = true;
        private boolean needVertical = true;
        private VisibilityProvider visibilityProvider;

        public Builder setColor(int color2) {
            this.color = color2;
            return this;
        }

        public Builder setThickness(int mThickness) {
            this.mThickness = mThickness;
            return this;
        }

        public Builder needHorizontal(boolean needHorizontal) {
            this.needHorizontal = needHorizontal;
            return this;
        }

        public Builder needVertical(boolean needVertical) {
            this.needVertical = needVertical;
            return this;
        }

        public Builder visibilityProvider(VisibilityProvider visibilityProvider) {
            this.visibilityProvider = visibilityProvider;
            return this;
        }

        public GridDividerDecoration build() {
            GridDividerDecoration decoration = new GridDividerDecoration(this.mThickness, this.color);
            decoration.needHorizontal = this.needHorizontal;
            decoration.needVertical = this.needVertical;
            decoration.visibilityProvider = this.visibilityProvider;
            return decoration;
        }
    }
}

