/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import java.util.ArrayList;
import tech.linjiang.pandora.network.CacheDbHelper;
import tech.linjiang.pandora.network.model.Summary;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.NetContentFragment;
import tech.linjiang.pandora.ui.item.KeyValueItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class NetSummaryFragment
extends BaseListFragment {
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        final long id2 = this.getArguments().getLong("param1");
        this.loadData(id2);
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                String tag;
                if (item instanceof KeyValueItem && !TextUtils.isEmpty((CharSequence)(tag = (String)item.getTag()))) {
                    Bundle bundle = new Bundle();
                    if ("param1".equals(tag)) {
                        bundle.putBoolean("param1", false);
                    } else if ("param2".equals(tag)) {
                        bundle.putBoolean("param1", true);
                    }
                    if (!bundle.isEmpty()) {
                        bundle.putLong("param2", id2);
                        NetSummaryFragment.this.launch(NetContentFragment.class, bundle);
                    }
                }
            }
        });
    }

    private void loadData(final long id2) {
        this.showLoading();
        new SimpleTask<Void, Summary>(new SimpleTask.Callback<Void, Summary>(){

            public Summary doInBackground(Void[] params) {
                return CacheDbHelper.getSummary(id2);
            }

            @Override
            public void onPostExecute(Summary summary) {
                NetSummaryFragment.this.hideLoading();
                if (summary == null) {
                    NetSummaryFragment.this.showError(null);
                }
                NetSummaryFragment.this.getToolbar().setTitle((CharSequence)summary.url);
                NetSummaryFragment.this.getToolbar().setSubtitle((CharSequence)String.valueOf(summary.code));
                ArrayList<BaseItem> data = new ArrayList<BaseItem>();
                data.add(new TitleItem("GENERAL"));
                data.add(new KeyValueItem(Utils.newArray("url", summary.url)));
                data.add(new KeyValueItem(Utils.newArray("host", summary.host)));
                data.add(new KeyValueItem(Utils.newArray("method", summary.method)));
                data.add(new KeyValueItem(Utils.newArray("protocol", summary.protocol)));
                data.add(new KeyValueItem(Utils.newArray("ssl", String.valueOf(summary.ssl))));
                data.add(new KeyValueItem(Utils.newArray("start_time", Utils.millis2String(summary.start_time))));
                data.add(new KeyValueItem(Utils.newArray("end_time", Utils.millis2String(summary.end_time))));
                data.add(new KeyValueItem(Utils.newArray("content-type", summary.response_content_type)));
                data.add(new KeyValueItem(Utils.newArray("request_size", Utils.formatSize(summary.request_size))));
                data.add(new KeyValueItem(Utils.newArray("response_size", Utils.formatSize(summary.response_size))));
                data.add(new TitleItem("BODY"));
                KeyValueItem request = new KeyValueItem(Utils.newArray("request body", "tap to view"), false, true);
                request.setTag("param1");
                data.add(request);
                if (summary.status == 2) {
                    KeyValueItem response = new KeyValueItem(Utils.newArray("response body", "tap to view"), false, true);
                    response.setTag("param2");
                    data.add(response);
                }
                if (Utils.isNotEmpty(summary.request_header)) {
                    data.add(new TitleItem("REQUEST HEADER"));
                    for (Pair<String, String> pair : summary.request_header) {
                        data.add(new KeyValueItem(Utils.newArray((String)pair.first, (String)pair.second)));
                    }
                }
                if (Utils.isNotEmpty(summary.response_header)) {
                    data.add(new TitleItem("RESPONSE HEADER"));
                    for (Pair<String, String> pair : summary.response_header) {
                        data.add(new KeyValueItem(Utils.newArray((String)pair.first, (String)pair.second)));
                    }
                }
                NetSummaryFragment.this.getAdapter().setItems(data);
            }
        }).execute(new Void[0]);
    }
}

