/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import java.util.ArrayList;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.connector.EditCallback;
import tech.linjiang.pandora.ui.fragment.BaseFragment;
import tech.linjiang.pandora.ui.item.OptionItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class EditFragment
extends BaseFragment {
    private EditText editText;
    private EditCallback callback;

    @Override
    protected int getLayoutId() {
        return 0;
    }

    @Override
    protected View getLayoutView() {
        EditText wrapper;
        this.editText = new EditText(this.getContext());
        int padding = ViewKnife.dip2px(16.0f);
        this.editText.setPadding(padding, padding, padding, padding);
        this.editText.setBackgroundColor(-1);
        this.editText.setGravity(0x800033);
        this.editText.setTextColor(ViewKnife.getColor(R.color.pd_label_dark));
        this.editText.setLineSpacing(0.0f, 1.2f);
        String[] options = this.getArguments().getStringArray("param3");
        if (options != null && options.length > 0) {
            LinearLayout layout2 = new LinearLayout(this.getContext());
            layout2.setOrientation(1);
            wrapper = layout2;
            RecyclerView recyclerView = new RecyclerView(this.getContext());
            recyclerView.setBackgroundColor(-1);
            LinearLayoutManager manager = new LinearLayoutManager(this.getContext());
            manager.setOrientation(0);
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)manager);
            UniversalAdapter adapter = new UniversalAdapter();
            recyclerView.setAdapter((RecyclerView.Adapter)adapter);
            adapter.setListener(new UniversalAdapter.OnItemClickListener(){

                @Override
                public void onItemClick(int position, BaseItem item) {
                    if (EditFragment.this.callback != null) {
                        EditFragment.this.callback.onValueChanged((String)((OptionItem)item).data);
                    }
                    EditFragment.this.onBackPressed();
                }
            });
            ArrayList<OptionItem> items = new ArrayList<OptionItem>(options.length);
            for (String option : options) {
                items.add(new OptionItem(option));
            }
            adapter.setItems(items);
            LinearLayout.LayoutParams recyclerParam = new LinearLayout.LayoutParams(-1, ViewKnife.dip2px(50.0f));
            layout2.addView((View)recyclerView, (ViewGroup.LayoutParams)recyclerParam);
            LinearLayout.LayoutParams editParam = new LinearLayout.LayoutParams(-1, -1);
            layout2.addView((View)this.editText, (ViewGroup.LayoutParams)editParam);
        } else {
            wrapper = this.editText;
        }
        return wrapper;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.callback = (EditCallback)this.getArguments().getSerializable("param2");
        this.getArguments().remove("param2");
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Edit");
        final String data = this.getArguments().getString("param1");
        this.editText.setText((CharSequence)data);
        this.editText.setSelection(this.editText.getText().length());
        this.editText.requestFocus();
        this.getToolbar().inflateMenu(R.menu.pd_menu_edit);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                String curValue = EditFragment.this.editText.getText().toString();
                if (!TextUtils.equals((CharSequence)curValue, (CharSequence)data)) {
                    if (EditFragment.this.callback != null) {
                        EditFragment.this.callback.onValueChanged(curValue);
                    }
                    EditFragment.this.onBackPressed();
                } else {
                    Utils.toast(R.string.pd_no_change);
                }
                return true;
            }
        });
    }

    @Override
    protected void onViewEnterAnimEnd(View container) {
        this.openSoftInput();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.closeSoftInput();
        this.callback = null;
    }
}

