/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import com.welie.blessed.bluez.BluezAdapter;
import com.welie.blessed.bluez.BluezAgentManager;
import com.welie.blessed.bluez.XmlHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.bluez.Adapter1;
import org.bluez.AgentManager1;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DbusHelper {
    private static final Logger LOGGER = Logger.getLogger(DbusHelper.class.getSimpleName());
    private static final String BLUEZ_PATH = "/org/bluez";

    private DbusHelper() {
    }

    public static Set<String> findNodes(DBusConnection _connection, String _path) {
        LinkedHashSet<String> foundNodes = new LinkedHashSet<String>();
        if (_connection == null || _path.length() == 0) {
            return foundNodes;
        }
        try {
            Introspectable remoteObject = (Introspectable)_connection.getRemoteObject("org.bluez", _path, Introspectable.class);
            String introspect = remoteObject.Introspect();
            Document doc = XmlHelper.parseXmlString(introspect);
            NodeList nodes = XmlHelper.applyXpathExpressionToDocument("/node/node", doc);
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!(nodes.item(i) instanceof Element)) continue;
                Element elem = (Element)nodes.item(i);
                foundNodes.add(elem.getAttribute("name"));
            }
            return foundNodes;
        }
        catch (DBusException _ex) {
            LOGGER.info(String.format("Exception while search DBus %s", new Object[]{_ex}));
        }
        catch (IOException _ex) {
            LOGGER.severe(String.format("Exception while applying Xpath to introspection result: %s", _ex));
        }
        catch (Exception _ex) {
            LOGGER.severe(String.format("Critical error while reading DBUS response (maybe no bluetoothd daemon running?): %s", _ex));
        }
        return foundNodes;
    }

    public static <T extends DBusInterface> T getRemoteObject(DBusConnection _connection, String _path, Class<T> _objClass) {
        try {
            return (T)_connection.getRemoteObject("org.bluez", _path, _objClass);
        }
        catch (DBusException _ex) {
            LOGGER.severe(String.format("Error while converting dbus response to object: %s", new Object[]{_ex}));
            return null;
        }
    }

    @NotNull
    public static @NotNull List<@NotNull BluezAdapter> findBluezAdapters(DBusConnection _connection) {
        LinkedHashMap<String, BluezAdapter> bluetoothAdaptersByAdapterName = new LinkedHashMap<String, BluezAdapter>();
        Set<String> nodes = DbusHelper.findNodes(_connection, BLUEZ_PATH);
        for (String hci : nodes) {
            Adapter1 adapter1 = DbusHelper.getRemoteObject(_connection, "/org/bluez/" + hci, Adapter1.class);
            if (adapter1 == null) continue;
            BluezAdapter bluetoothAdapter = new BluezAdapter(adapter1, "/org/bluez/" + hci, _connection);
            bluetoothAdaptersByAdapterName.put(hci, bluetoothAdapter);
        }
        return new ArrayList<BluezAdapter>(bluetoothAdaptersByAdapterName.values());
    }

    @Nullable
    public static BluezAgentManager getBluezAgentManager(DBusConnection _connection) {
        BluezAgentManager bluetoothAgentManager = null;
        AgentManager1 agentManager1 = DbusHelper.getRemoteObject(_connection, BLUEZ_PATH, AgentManager1.class);
        if (agentManager1 != null) {
            bluetoothAgentManager = new BluezAgentManager(agentManager1, agentManager1.getObjectPath(), _connection);
        }
        return bluetoothAgentManager;
    }
}

