/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import com.welie.blessed.bluez.AbstractBluetoothObject;
import com.welie.blessed.bluez.BluezDeviceType;
import com.welie.blessed.bluez.PairingAgent;
import org.bluez.AgentManager1;
import org.bluez.exceptions.BluezAlreadyExistsException;
import org.bluez.exceptions.BluezDoesNotExistException;
import org.bluez.exceptions.BluezInvalidArgumentsException;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;

public class BluezAgentManager
extends AbstractBluetoothObject {
    private final AgentManager1 rawAgentManager;

    public BluezAgentManager(AgentManager1 _agentManager, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluezDeviceType.AGENT_MANAGER, _dbusConnection, _dbusPath);
        this.rawAgentManager = _agentManager;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return AgentManager1.class;
    }

    public void registerAgent(PairingAgent bluetoothAgent, String _capability) throws BluezInvalidArgumentsException, BluezAlreadyExistsException {
        this.rawAgentManager.RegisterAgent(new DBusPath(bluetoothAgent.getDbusPath()), _capability);
    }

    public void unregisterAgent(PairingAgent bluetoothAgent) throws BluezDoesNotExistException {
        this.rawAgentManager.UnregisterAgent(new DBusPath(bluetoothAgent.getDbusPath()));
    }

    public void requestDefaultAgent(PairingAgent bluetoothAgent) throws BluezDoesNotExistException {
        this.rawAgentManager.RequestDefaultAgent(new DBusPath(bluetoothAgent.getDbusPath()));
    }
}

