/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.spi;

import java.io.IOException;
import java.io.OutputStream;
import org.freedesktop.Hexdump;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.spi.IMessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputStreamMessageWriter
implements IMessageWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OutputStream outputStream;

    public OutputStreamMessageWriter(OutputStream _out) {
        this.outputStream = _out;
    }

    @Override
    public void writeMessage(Message m3) throws IOException {
        this.logger.debug("<= {}", (Object)m3);
        if (null == m3) {
            return;
        }
        if (null == m3.getWireData()) {
            this.logger.warn("Message {} wire-data was null!", (Object)m3);
            return;
        }
        for (byte[] buf : m3.getWireData()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("{}", (Object)(null == buf ? "" : Hexdump.format(buf)));
            }
            if (null == buf) break;
            this.outputStream.write(buf);
        }
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.logger.debug("Closing Message Writer");
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        this.outputStream = null;
    }

    @Override
    public boolean isClosed() {
        return this.outputStream == null;
    }
}

