/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import jnr.posix.POSIXFactory;
import jnr.unixsocket.Credentials;
import jnr.unixsocket.UnixSocket;
import org.freedesktop.Hexdump;
import org.freedesktop.dbus.connections.FreeBSDHelper;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASL {
    public static final int LOCK_TIMEOUT = 1000;
    public static final int NEW_KEY_TIMEOUT_SECONDS = 300;
    public static final int EXPIRE_KEYS_TIMEOUT_SECONDS = 420;
    public static final int MAX_TIME_TRAVEL_SECONDS = 300;
    public static final int COOKIE_TIMEOUT = 240;
    public static final String COOKIE_CONTEXT = "org_freedesktop_java";
    private static Collator col = Collator.getInstance();
    private String challenge = "";
    private String cookie = "";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean fileDescriptorSupported;
    private boolean hasFileDescriptorSupport;
    public static final int AUTH_NONE = 0;
    public static final int AUTH_EXTERNAL = 1;
    public static final int AUTH_SHA = 2;
    public static final int AUTH_ANON = 4;

    public SASL() {
        this(false);
    }

    public SASL(boolean _hasFileDescriptorSupport) {
        this.hasFileDescriptorSupport = _hasFileDescriptorSupport;
    }

    private String findCookie(String context, String ID2) throws IOException {
        String homedir = System.getProperty("user.home");
        File f = new File(homedir + "/.dbus-keyrings/" + context);
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        String s2 = null;
        String lCookie = null;
        long now = System.currentTimeMillis() / 1000L;
        while (null != (s2 = r.readLine())) {
            String[] line = s2.split(" ");
            long timestamp = Long.parseLong(line[1]);
            if (!line[0].equals(ID2) || timestamp < 0L || now + 300L < timestamp || now - 420L > timestamp) continue;
            lCookie = line[2];
            break;
        }
        r.close();
        return lCookie;
    }

    private void addCookie(String _context, String _id, long _timestamp, String _cookie) throws IOException {
        String homedir = System.getProperty("user.home");
        File keydir = new File(homedir + "/.dbus-keyrings/");
        File cookiefile = new File(homedir + "/.dbus-keyrings/" + _context);
        File lock = new File(homedir + "/.dbus-keyrings/" + _context + ".lock");
        File temp = new File(homedir + "/.dbus-keyrings/" + _context + ".temp");
        if (!keydir.exists()) {
            keydir.mkdirs();
        }
        long start = System.currentTimeMillis();
        while (!lock.createNewFile() && 1000L > System.currentTimeMillis() - start) {
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (cookiefile.exists()) {
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(cookiefile)));
            String s2 = null;
            while (null != (s2 = r.readLine())) {
                String[] line = s2.split(" ");
                long time = Long.parseLong(line[1]);
                if (_timestamp - time >= 240L) continue;
                lines.add(s2);
            }
            r.close();
        }
        lines.add(_id + " " + _timestamp + " " + _cookie);
        PrintWriter w = new PrintWriter(new FileOutputStream(temp));
        for (String l : lines) {
            w.println(l);
        }
        w.close();
        if (!temp.renameTo(cookiefile)) {
            cookiefile.delete();
            temp.renameTo(cookiefile);
        }
        lock.delete();
    }

    private String stupidlyEncode(String data) {
        return Hexdump.toHex(data.getBytes()).replaceAll(" ", "");
    }

    private String stupidlyEncode(byte[] data) {
        return Hexdump.toHex(data).replaceAll(" ", "");
    }

    private byte getNibble(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return (byte)(c - 48);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return (byte)(c - 65 + 10);
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return (byte)(c - 97 + 10);
            }
        }
        return 0;
    }

    private String stupidlyDecode(String data) {
        char[] cs = new char[data.length()];
        char[] res = new char[cs.length / 2];
        data.getChars(0, data.length(), cs, 0);
        int i = 0;
        for (int j = 0; j < res.length; ++j) {
            int b = 0;
            b |= this.getNibble(cs[i]) << 4;
            res[j] = (char)(b |= this.getNibble(cs[i + 1]));
            i += 2;
        }
        return new String(res);
    }

    public Command receive(InputStream s2) throws IOException {
        StringBuffer sb = new StringBuffer();
        block7: while (true) {
            int c = s2.read();
            switch (c) {
                case -1: {
                    throw new IOException("Stream unexpectedly short (broken pipe)");
                }
                case 0: 
                case 13: {
                    continue block7;
                }
                case 10: {
                    break block7;
                }
                default: {
                    sb.append((char)c);
                    continue block7;
                }
            }
            break;
        }
        this.logger.trace("received: {}", (Object)sb);
        try {
            return new Command(sb.toString());
        }
        catch (Exception e) {
            this.logger.error("Cannot create command.", e);
            return new Command();
        }
    }

    public void send(OutputStream out, SaslCommand command, String ... data) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(command.name());
        for (String s2 : data) {
            sb.append(' ');
            sb.append(s2);
        }
        sb.append('\r');
        sb.append('\n');
        this.logger.trace("sending: {}", (Object)sb);
        out.write(sb.toString().getBytes());
    }

    public SaslResult doChallenge(int _auth, Command c) throws IOException {
        switch (_auth) {
            case 2: {
                Object[] reply = this.stupidlyDecode(c.getData()).split(" ");
                this.logger.trace(Arrays.toString(reply));
                if (3 != reply.length) {
                    this.logger.debug("Reply is not length 3");
                    return SaslResult.ERROR;
                }
                Object context = reply[0];
                Object id = reply[1];
                Object serverchallenge = reply[2];
                MessageDigest md = null;
                try {
                    md = MessageDigest.getInstance("SHA");
                }
                catch (NoSuchAlgorithmException nsae) {
                    this.logger.debug("", nsae);
                    return SaslResult.ERROR;
                }
                byte[] buf = new byte[8];
                Message.marshallintBig(System.currentTimeMillis(), buf, 0, 8);
                String clientchallenge = this.stupidlyEncode(md.digest(buf));
                md.reset();
                long start = System.currentTimeMillis();
                String lCookie = null;
                while (null == lCookie && System.currentTimeMillis() - start < 1000L) {
                    lCookie = this.findCookie((String)context, (String)id);
                }
                if (null == lCookie) {
                    this.logger.debug("Did not find a cookie in context {}  with ID {}", context, id);
                    return SaslResult.ERROR;
                }
                String response = (String)serverchallenge + ":" + clientchallenge + ":" + lCookie;
                buf = md.digest(response.getBytes());
                this.logger.trace("Response: {} hash: {}", (Object)response, (Object)Hexdump.format(buf));
                response = this.stupidlyEncode(buf);
                c.setResponse(this.stupidlyEncode(clientchallenge + " " + response));
                return SaslResult.OK;
            }
        }
        this.logger.debug("Not DBUS_COOKIE_SHA1 authtype.");
        return SaslResult.ERROR;
    }

    public SaslResult doResponse(int _auth, String _uid, String _kernelUid, Command _c) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            this.logger.error("", nsae);
            return SaslResult.ERROR;
        }
        switch (_auth) {
            case 0: {
                switch (_c.getMechs()) {
                    case 4: {
                        return SaslResult.OK;
                    }
                    case 1: {
                        if (0 == col.compare(_uid, _c.getData()) && (null == _kernelUid || 0 == col.compare(_uid, _kernelUid))) {
                            return SaslResult.OK;
                        }
                        return SaslResult.REJECT;
                    }
                    case 2: {
                        String context = COOKIE_CONTEXT;
                        long id = System.currentTimeMillis();
                        byte[] buf = new byte[8];
                        Message.marshallintBig(id, buf, 0, 8);
                        this.challenge = this.stupidlyEncode(md.digest(buf));
                        Random r = new Random();
                        r.nextBytes(buf);
                        this.cookie = this.stupidlyEncode(md.digest(buf));
                        try {
                            this.addCookie(context, "" + id, id / 1000L, this.cookie);
                        }
                        catch (IOException ioe) {
                            this.logger.debug("", ioe);
                        }
                        this.logger.debug("Sending challenge: {} {} {}", context, id, this.challenge);
                        _c.setResponse(this.stupidlyEncode(context + ' ' + id + ' ' + this.challenge));
                        return SaslResult.CONTINUE;
                    }
                }
                return SaslResult.ERROR;
            }
            case 2: {
                String[] response = this.stupidlyDecode(_c.getData()).split(" ");
                if (response.length < 2) {
                    return SaslResult.ERROR;
                }
                String cchal = response[0];
                String hash = response[1];
                String prehash = this.challenge + ":" + cchal + ":" + this.cookie;
                byte[] buf = md.digest(prehash.getBytes());
                String posthash = this.stupidlyEncode(buf);
                this.logger.debug("Authenticating Hash; data={} remote-hash={} local-hash={}", prehash, hash, posthash);
                if (0 == col.compare(posthash, hash)) {
                    return SaslResult.OK;
                }
                return SaslResult.ERROR;
            }
        }
        return SaslResult.ERROR;
    }

    public String[] getTypes(int types) {
        switch (types) {
            case 1: {
                return new String[]{"EXTERNAL"};
            }
            case 2: {
                return new String[]{"DBUS_COOKIE_SHA1"};
            }
            case 4: {
                return new String[]{"ANONYMOUS"};
            }
            case 3: {
                return new String[]{"EXTERNAL", "DBUS_COOKIE_SHA1"};
            }
            case 6: {
                return new String[]{"ANONYMOUS", "DBUS_COOKIE_SHA1"};
            }
            case 5: {
                return new String[]{"ANONYMOUS", "EXTERNAL"};
            }
            case 7: {
                return new String[]{"ANONYMOUS", "EXTERNAL", "DBUS_COOKIE_SHA1"};
            }
        }
        return new String[0];
    }

    public boolean auth(SaslMode mode, int types, String guid, OutputStream out, InputStream in, Socket us) throws IOException {
        String luid = null;
        String kernelUid = null;
        long uid = POSIXFactory.getJavaPOSIX().getuid();
        luid = this.stupidlyEncode("" + uid);
        int failed = 0;
        int current = 0;
        SaslAuthState state = SaslAuthState.INITIAL_STATE;
        block60: while (state != SaslAuthState.FINISHED && state != SaslAuthState.FAILED) {
            this.logger.trace("Mode: {} AUTH state: {}", (Object)mode, (Object)state);
            switch (mode) {
                case CLIENT: {
                    Command c;
                    switch (state) {
                        case INITIAL_STATE: {
                            if (FreeBSDHelper.isFreeBSD()) {
                                FreeBSDHelper.send_cred(us);
                            } else {
                                out.write(new byte[]{0});
                            }
                            this.send(out, SaslCommand.AUTH, new String[0]);
                            state = SaslAuthState.WAIT_DATA;
                            continue block60;
                        }
                        case WAIT_DATA: {
                            c = this.receive(in);
                            switch (c.getCommand()) {
                                case DATA: {
                                    switch (this.doChallenge(current, c)) {
                                        case CONTINUE: {
                                            this.send(out, SaslCommand.DATA, c.getResponse());
                                            continue block60;
                                        }
                                        case OK: {
                                            this.send(out, SaslCommand.DATA, c.getResponse());
                                            state = SaslAuthState.WAIT_OK;
                                            continue block60;
                                        }
                                    }
                                    this.send(out, SaslCommand.ERROR, c.getResponse());
                                    continue block60;
                                }
                                case REJECTED: {
                                    int available = c.getMechs() & ~(failed |= current);
                                    if (0 != (available & 1)) {
                                        this.send(out, SaslCommand.AUTH, "EXTERNAL", luid);
                                        current = 1;
                                        continue block60;
                                    }
                                    if (0 != (available & 2)) {
                                        this.send(out, SaslCommand.AUTH, "DBUS_COOKIE_SHA1", luid);
                                        current = 2;
                                        continue block60;
                                    }
                                    if (0 != (available & 4)) {
                                        this.send(out, SaslCommand.AUTH, "ANONYMOUS");
                                        current = 4;
                                        continue block60;
                                    }
                                    state = SaslAuthState.FAILED;
                                    continue block60;
                                }
                                case ERROR: {
                                    if (state == SaslAuthState.NEGOTIATE_UNIX_FD) {
                                        state = SaslAuthState.FINISHED;
                                        this.logger.trace("File descriptors NOT supported by server");
                                        this.fileDescriptorSupported = false;
                                        this.send(out, SaslCommand.BEGIN, new String[0]);
                                        continue block60;
                                    }
                                    this.send(out, SaslCommand.CANCEL, new String[0]);
                                    state = SaslAuthState.WAIT_REJECT;
                                    continue block60;
                                }
                                case OK: {
                                    this.logger.trace("Authenticated");
                                    state = SaslAuthState.AUTHENTICATED;
                                    if (this.hasFileDescriptorSupport) {
                                        state = SaslAuthState.WAIT_DATA;
                                        this.logger.trace("Asking for file descriptor support");
                                        this.send(out, SaslCommand.NEGOTIATE_UNIX_FD, new String[0]);
                                        continue block60;
                                    }
                                    state = SaslAuthState.FINISHED;
                                    this.send(out, SaslCommand.BEGIN, new String[0]);
                                    continue block60;
                                }
                                case AGREE_UNIX_FD: {
                                    if (!this.hasFileDescriptorSupport) continue block60;
                                    state = SaslAuthState.FINISHED;
                                    this.logger.trace("File descriptors supported by server");
                                    this.fileDescriptorSupported = true;
                                    this.send(out, SaslCommand.BEGIN, new String[0]);
                                    continue block60;
                                }
                            }
                            this.send(out, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                        case WAIT_OK: {
                            c = this.receive(in);
                            switch (c.getCommand()) {
                                case OK: {
                                    this.send(out, SaslCommand.BEGIN, new String[0]);
                                    state = SaslAuthState.AUTHENTICATED;
                                    continue block60;
                                }
                                case DATA: 
                                case ERROR: {
                                    this.send(out, SaslCommand.CANCEL, new String[0]);
                                    state = SaslAuthState.WAIT_REJECT;
                                    continue block60;
                                }
                                case REJECTED: {
                                    int available = c.getMechs() & ~(failed |= current);
                                    state = SaslAuthState.WAIT_DATA;
                                    if (0 != (available & 1)) {
                                        this.send(out, SaslCommand.AUTH, "EXTERNAL", luid);
                                        current = 1;
                                        continue block60;
                                    }
                                    if (0 != (available & 2)) {
                                        this.send(out, SaslCommand.AUTH, "DBUS_COOKIE_SHA1", luid);
                                        current = 2;
                                        continue block60;
                                    }
                                    if (0 != (available & 4)) {
                                        this.send(out, SaslCommand.AUTH, "ANONYMOUS");
                                        current = 4;
                                        continue block60;
                                    }
                                    state = SaslAuthState.FAILED;
                                    continue block60;
                                }
                            }
                            this.send(out, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                        case WAIT_REJECT: {
                            c = this.receive(in);
                            switch (c.getCommand()) {
                                case REJECTED: {
                                    int available = c.getMechs() & ~(failed |= current);
                                    if (0 != (available & 1)) {
                                        this.send(out, SaslCommand.AUTH, "EXTERNAL", luid);
                                        current = 1;
                                        continue block60;
                                    }
                                    if (0 != (available & 2)) {
                                        this.send(out, SaslCommand.AUTH, "DBUS_COOKIE_SHA1", luid);
                                        current = 2;
                                        continue block60;
                                    }
                                    if (0 != (available & 4)) {
                                        this.send(out, SaslCommand.AUTH, "ANONYMOUS");
                                        current = 4;
                                        continue block60;
                                    }
                                    state = SaslAuthState.FAILED;
                                    continue block60;
                                }
                            }
                            state = SaslAuthState.FAILED;
                            continue block60;
                        }
                    }
                    state = SaslAuthState.FAILED;
                    continue block60;
                }
                case SERVER: {
                    Command c;
                    switch (state) {
                        case INITIAL_STATE: {
                            byte[] buf = new byte[1];
                            if (null == us) {
                                in.read(buf);
                                state = SaslAuthState.WAIT_AUTH;
                                continue block60;
                            }
                            try {
                                if (FreeBSDHelper.isFreeBSD()) {
                                    long euid = FreeBSDHelper.recv_cred(us);
                                    if (euid >= 0L) {
                                        kernelUid = this.stupidlyEncode("" + euid);
                                    }
                                } else {
                                    Credentials credentials = ((UnixSocket)us).getCredentials();
                                    int kuid = credentials.getUid();
                                    if (kuid >= 0) {
                                        kernelUid = this.stupidlyEncode("" + kuid);
                                    }
                                }
                                state = SaslAuthState.WAIT_AUTH;
                            }
                            catch (SocketException _ex) {
                                state = SaslAuthState.FAILED;
                            }
                            continue block60;
                        }
                        case WAIT_AUTH: {
                            c = this.receive(in);
                            switch (c.getCommand()) {
                                case AUTH: {
                                    switch (this.doResponse(current, luid, kernelUid, c)) {
                                        case CONTINUE: {
                                            this.send(out, SaslCommand.DATA, c.getResponse());
                                            current = c.getMechs();
                                            state = SaslAuthState.WAIT_DATA;
                                            continue block60;
                                        }
                                        case OK: {
                                            this.send(out, SaslCommand.OK, guid);
                                            state = SaslAuthState.WAIT_BEGIN;
                                            current = 0;
                                            continue block60;
                                        }
                                    }
                                    this.send(out, SaslCommand.REJECTED, this.getTypes(types));
                                    current = 0;
                                    continue block60;
                                }
                                case ERROR: {
                                    this.send(out, SaslCommand.REJECTED, this.getTypes(types));
                                    continue block60;
                                }
                                case BEGIN: {
                                    state = SaslAuthState.FAILED;
                                    continue block60;
                                }
                            }
                            this.send(out, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                        case WAIT_DATA: {
                            c = this.receive(in);
                            switch (c.getCommand()) {
                                case DATA: {
                                    switch (this.doResponse(current, luid, kernelUid, c)) {
                                        case CONTINUE: {
                                            this.send(out, SaslCommand.DATA, c.getResponse());
                                            state = SaslAuthState.WAIT_DATA;
                                            continue block60;
                                        }
                                        case OK: {
                                            this.send(out, SaslCommand.OK, guid);
                                            state = SaslAuthState.WAIT_BEGIN;
                                            current = 0;
                                            continue block60;
                                        }
                                    }
                                    this.send(out, SaslCommand.REJECTED, this.getTypes(types));
                                    current = 0;
                                    continue block60;
                                }
                                case ERROR: 
                                case CANCEL: {
                                    this.send(out, SaslCommand.REJECTED, this.getTypes(types));
                                    state = SaslAuthState.WAIT_AUTH;
                                    continue block60;
                                }
                                case BEGIN: {
                                    state = SaslAuthState.FAILED;
                                    continue block60;
                                }
                            }
                            this.send(out, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                        case WAIT_BEGIN: {
                            c = this.receive(in);
                            switch (c.getCommand()) {
                                case ERROR: 
                                case CANCEL: {
                                    this.send(out, SaslCommand.REJECTED, this.getTypes(types));
                                    state = SaslAuthState.WAIT_AUTH;
                                    continue block60;
                                }
                                case BEGIN: {
                                    state = SaslAuthState.FINISHED;
                                    continue block60;
                                }
                                case NEGOTIATE_UNIX_FD: {
                                    this.logger.debug("File descriptor negotiation requested");
                                    if (!this.hasFileDescriptorSupport) {
                                        this.send(out, SaslCommand.ERROR, new String[0]);
                                        continue block60;
                                    }
                                    this.send(out, SaslCommand.AGREE_UNIX_FD, new String[0]);
                                    continue block60;
                                }
                            }
                            this.send(out, SaslCommand.ERROR, "Got invalid command");
                            continue block60;
                        }
                    }
                    state = SaslAuthState.FAILED;
                    continue block60;
                }
            }
            return false;
        }
        return state == SaslAuthState.FINISHED;
    }

    public boolean isFileDescriptorSupported() {
        return this.fileDescriptorSupported;
    }

    static {
        col.setDecomposition(2);
        col.setStrength(0);
    }

    public static class Command {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private SaslCommand command;
        private int mechs;
        private String data;
        private String response;

        public Command() {
        }

        public Command(String s2) throws IOException {
            Object[] ss = s2.split(" ");
            this.logger.trace("Creating command from: {}", (Object)Arrays.toString(ss));
            if (0 == col.compare((String)ss[0], "OK")) {
                this.command = SaslCommand.OK;
                this.data = ss[1];
            } else if (0 == col.compare((String)ss[0], "AUTH")) {
                this.command = SaslCommand.AUTH;
                if (ss.length > 1) {
                    if (0 == col.compare((String)ss[1], "EXTERNAL")) {
                        this.mechs = 1;
                    } else if (0 == col.compare((String)ss[1], "DBUS_COOKIE_SHA1")) {
                        this.mechs = 2;
                    } else if (0 == col.compare((String)ss[1], "ANONYMOUS")) {
                        this.mechs = 4;
                    }
                }
                if (ss.length > 2) {
                    this.data = ss[2];
                }
            } else if (0 == col.compare((String)ss[0], "DATA")) {
                this.command = SaslCommand.DATA;
                this.data = ss[1];
            } else if (0 == col.compare((String)ss[0], "REJECTED")) {
                this.command = SaslCommand.REJECTED;
                for (int i = 1; i < ss.length; ++i) {
                    if (0 == col.compare((String)ss[i], "EXTERNAL")) {
                        this.mechs |= 1;
                        continue;
                    }
                    if (0 == col.compare((String)ss[i], "DBUS_COOKIE_SHA1")) {
                        this.mechs |= 2;
                        continue;
                    }
                    if (0 != col.compare((String)ss[i], "ANONYMOUS")) continue;
                    this.mechs |= 4;
                }
            } else if (0 == col.compare((String)ss[0], "BEGIN")) {
                this.command = SaslCommand.BEGIN;
            } else if (0 == col.compare((String)ss[0], "CANCEL")) {
                this.command = SaslCommand.CANCEL;
            } else if (0 == col.compare((String)ss[0], "ERROR")) {
                this.command = SaslCommand.ERROR;
                this.data = ss[1];
            } else if (0 == col.compare((String)ss[0], "NEGOTIATE_UNIX_FD")) {
                this.command = SaslCommand.NEGOTIATE_UNIX_FD;
            } else if (0 == col.compare((String)ss[0], "AGREE_UNIX_FD")) {
                this.command = SaslCommand.AGREE_UNIX_FD;
            } else {
                throw new IOException("Invalid Command " + (String)ss[0]);
            }
            this.logger.trace("Created command: {}", (Object)this);
        }

        public SaslCommand getCommand() {
            return this.command;
        }

        public int getMechs() {
            return this.mechs;
        }

        public String getData() {
            return this.data;
        }

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String s2) {
            this.response = s2;
        }

        public String toString() {
            return "Command(" + (Object)((Object)this.command) + ", " + this.mechs + ", " + this.data + ")";
        }
    }

    static enum SaslResult {
        OK,
        CONTINUE,
        ERROR,
        REJECT;

    }

    static enum SaslAuthState {
        INITIAL_STATE,
        WAIT_DATA,
        WAIT_OK,
        WAIT_REJECT,
        WAIT_AUTH,
        WAIT_BEGIN,
        AUTHENTICATED,
        NEGOTIATE_UNIX_FD,
        FINISHED,
        FAILED;

    }

    static enum SaslCommand {
        AUTH,
        DATA,
        REJECTED,
        OK,
        BEGIN,
        CANCEL,
        ERROR,
        NEGOTIATE_UNIX_FD,
        AGREE_UNIX_FD;

    }

    public static enum SaslMode {
        SERVER,
        CLIENT;

    }
}

