/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerSet
implements Set<String>,
DBusSigHandler<DBus.NameOwnerChanged> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<String> addresses = new TreeSet<String>();

    public PeerSet(DBusConnection _connection) {
        try {
            _connection.addSigHandler(new DBusMatchRule(DBus.NameOwnerChanged.class, null, null), this);
        }
        catch (DBusException dbe) {
            this.logger.debug("", dbe);
        }
    }

    @Override
    public void handle(DBus.NameOwnerChanged noc) {
        this.logger.debug("Received NameOwnerChanged({}, {}, {})", noc.name, noc.oldOwner, noc.newOwner);
        if ("".equals(noc.newOwner) && this.addresses.contains(noc.name)) {
            this.remove(noc.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String address) {
        this.logger.debug("Adding {}", (Object)address);
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.add(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends String> _addresses) {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.addAll(_addresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Set<String> set = this.addresses;
        synchronized (set) {
            this.addresses.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.addresses.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> os) {
        return this.addresses.containsAll(os);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PeerSet) {
            return ((PeerSet)o).addresses.equals(this.addresses);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.addresses.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.addresses.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.addresses.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.logger.debug("Removing {}", o);
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> os) {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.removeAll(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> os) {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.retainAll(os);
        }
    }

    @Override
    public int size() {
        return this.addresses.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Set<String> set = this.addresses;
        synchronized (set) {
            return this.addresses.toArray(a);
        }
    }
}

