/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.messages.ExportedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackContainer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String[], ExportedObject> fallbacks = new HashMap<String[], ExportedObject>();

    FallbackContainer() {
    }

    public synchronized void add(String path, ExportedObject eo) {
        this.logger.debug("Adding fallback on {} of {}", (Object)path, (Object)eo);
        this.fallbacks.put(path.split("/"), eo);
    }

    public synchronized void remove(String path) {
        this.logger.debug("Removing fallback on {}", (Object)path);
        this.fallbacks.remove(path.split("/"));
    }

    public synchronized ExportedObject get(String path) {
        int best = 0;
        int i = 0;
        ExportedObject bestobject = null;
        Object[] pathel = path.split("/");
        for (Object[] objectArray : this.fallbacks.keySet()) {
            this.logger.trace("Trying fallback path {} to match {}", (Object)Arrays.deepToString(objectArray), (Object)Arrays.deepToString(pathel));
            for (i = 0; i < pathel.length && i < objectArray.length && ((String)pathel[i]).equals(objectArray[i]); ++i) {
            }
            if (i > 0 && i == objectArray.length && i > best) {
                bestobject = this.fallbacks.get(objectArray);
            }
            this.logger.trace("Matches {} bestobject now {}", (Object)i, (Object)bestobject);
        }
        this.logger.debug("Found fallback for {} of {}", (Object)path, (Object)bestobject);
        return bestobject;
    }
}

