/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.freedesktop.dbus.exceptions.MarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDescriptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int m_fd;

    public FileDescriptor(int _fd) {
        this.m_fd = _fd;
    }

    public FileDescriptor(java.io.FileDescriptor _data) throws MarshallingException {
        this.m_fd = this.getFileDescriptor(_data);
    }

    public java.io.FileDescriptor toJavaFileDescriptor() throws MarshallingException {
        return this.createFileDescriptorByReflection(this.m_fd);
    }

    public int getIntFileDescriptor() {
        return this.m_fd;
    }

    private int getFileDescriptor(java.io.FileDescriptor _data) throws MarshallingException {
        try {
            Field declaredField = _data.getClass().getDeclaredField("fd");
            declaredField.setAccessible(true);
            return declaredField.getInt(_data);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException _ex) {
            this.logger.error("Could not get filedescriptor by reflection.", _ex);
            throw new MarshallingException("Could not get member 'fd' of FileDescriptor by reflection!", _ex);
        }
    }

    private java.io.FileDescriptor createFileDescriptorByReflection(long _demarshallint) throws MarshallingException {
        try {
            Constructor constructor = java.io.FileDescriptor.class.getDeclaredConstructor(Integer.TYPE);
            constructor.setAccessible(true);
            return (java.io.FileDescriptor)constructor.newInstance((int)_demarshallint);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException _ex) {
            this.logger.error("Could not create new FileDescriptor instance by reflection.", _ex);
            throw new MarshallingException("Could not create new FileDescriptor instance by reflection", _ex);
        }
    }
}

