/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.BluezAdapterProvider;
import com.welie.blessed.BluezSignalHandler;
import com.welie.blessed.ConnectionState;
import com.welie.blessed.Handler;
import com.welie.blessed.ScanResult;
import com.welie.blessed.bluez.BluezAdapter;
import com.welie.blessed.bluez.BluezAgentManager;
import com.welie.blessed.bluez.BluezDevice;
import com.welie.blessed.bluez.DbusHelper;
import com.welie.blessed.bluez.DiscoveryFilter;
import com.welie.blessed.bluez.DiscoveryTransport;
import com.welie.blessed.bluez.PairingAgent;
import com.welie.blessed.bluez.PairingDelegate;
import com.welie.blessed.internal.InternalCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.bluez.Device1;
import org.bluez.exceptions.BluezAlreadyExistsException;
import org.bluez.exceptions.BluezDoesNotExistException;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInvalidArgumentsException;
import org.bluez.exceptions.BluezNotAuthorizedException;
import org.bluez.exceptions.BluezNotReadyException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.DBusMap;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.handlers.AbstractPropertiesChangedHandler;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothCentralManager {
    private static final String TAG = BluetoothCentralManager.class.getSimpleName();
    private final Logger logger = LoggerFactory.getLogger(TAG);
    @NotNull
    private final BluezAdapter adapter;
    @NotNull
    private final BluetoothCentralManagerCallback bluetoothCentralManagerCallback;
    @NotNull
    private final Handler callBackHandler = new Handler("Central-callback");
    @NotNull
    private final Handler queueHandler = new Handler("Central-queue");
    @NotNull
    private final Handler signalHandler = new Handler("Central-signal");
    @Nullable
    private ScheduledFuture<?> timeoutFuture;
    protected volatile boolean isScanning = false;
    private volatile boolean isPowered = false;
    private volatile boolean isStoppingScan = false;
    private volatile boolean autoScanActive = false;
    private volatile boolean normalScanActive = false;
    private volatile boolean commandQueueBusy;
    @NotNull
    protected final Map<DiscoveryFilter, Object> scanFilters = new EnumMap<DiscoveryFilter, Object>(DiscoveryFilter.class);
    @NotNull
    protected final Queue<Runnable> commandQueue = new ConcurrentLinkedQueue<Runnable>();
    @NotNull
    private String currentCommand = "";
    @NotNull
    private String currentDeviceAddress = "";
    @NotNull
    private final Map<String, BluetoothPeripheral> connectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    @NotNull
    private final Map<String, BluetoothPeripheral> unconnectedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    @NotNull
    private final Map<String, BluezDevice> scannedBluezDevices = new ConcurrentHashMap<String, BluezDevice>();
    @NotNull
    private final Map<String, BluetoothPeripheral> scannedPeripherals = new ConcurrentHashMap<String, BluetoothPeripheral>();
    @NotNull
    private final Map<String, ScanResult> scanResultCache = new ConcurrentHashMap<String, ScanResult>();
    @NotNull
    protected Set<String> scanPeripheralNames = new HashSet<String>();
    @NotNull
    protected Set<String> scanPeripheralAddresses = new HashSet<String>();
    @NotNull
    protected Set<UUID> scanServiceUUIDs = new HashSet<UUID>();
    @NotNull
    protected final List<String> reconnectPeripheralAddresses = new ArrayList<String>();
    @NotNull
    protected final Map<String, BluetoothPeripheralCallback> reconnectCallbacks = new ConcurrentHashMap<String, BluetoothPeripheralCallback>();
    @NotNull
    protected final Map<String, String> pinCodes = new ConcurrentHashMap<String, String>();
    @NotNull
    private final Set<String> scanOptions;
    private static final int ADDRESS_LENGTH = 17;
    static final short DISCOVERY_RSSI_THRESHOLD = -80;
    private static final long SCAN_WINDOW = TimeUnit.SECONDS.toMillis(6L);
    private static final long SCAN_INTERVAL = TimeUnit.SECONDS.toMillis(8L);
    protected static final long CONNECT_DELAY = TimeUnit.MILLISECONDS.toMillis(500L);
    private static final String NULL_PERIPHERAL_ERROR = "no valid peripheral specified";
    static final String PROPERTY_DISCOVERING = "Discovering";
    static final String PROPERTY_POWERED = "Powered";
    protected static final String BLUEZ_ADAPTER_INTERFACE = "org.bluez.Adapter1";
    private static final String ENQUEUE_ERROR = "ERROR: Could not enqueue stop scanning command";
    public static final String SCANOPTION_NO_NULL_NAMES = "ScanOption.NoNullNames";
    private final InternalCallback internalCallback = new InternalCallback(){

        @Override
        public void connected(@NotNull BluetoothPeripheral peripheral) {
            String peripheralAddress = peripheral.getAddress();
            BluetoothCentralManager.this.connectedPeripherals.put(peripheralAddress, peripheral);
            BluetoothCentralManager.this.unconnectedPeripherals.remove(peripheralAddress);
            BluetoothCentralManager.this.scannedPeripherals.remove(peripheralAddress);
            this.completeConnectOrDisconnectCommand(peripheralAddress);
            BluetoothCentralManager.this.callBackHandler.post(() -> BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectedPeripheral(peripheral));
        }

        @Override
        public void servicesDiscovered(@NotNull BluetoothPeripheral peripheral) {
            this.restartScannerIfNeeded();
        }

        @Override
        public void serviceDiscoveryFailed(@NotNull BluetoothPeripheral peripheral) {
            BluetoothCentralManager.this.logger.info("Service discovery failed");
            if (peripheral.isPaired()) {
                BluetoothCentralManager.this.callBackHandler.postDelayed(() -> BluetoothCentralManager.this.removeDevice(peripheral), 200L);
            }
        }

        @Override
        public void connectFailed(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothCommandStatus status) {
            String peripheralAddress = peripheral.getAddress();
            BluetoothCentralManager.this.connectedPeripherals.remove(peripheralAddress);
            BluetoothCentralManager.this.unconnectedPeripherals.remove(peripheralAddress);
            BluetoothCentralManager.this.scannedPeripherals.remove(peripheralAddress);
            this.completeConnectOrDisconnectCommand(peripheralAddress);
            BluetoothCentralManager.this.callBackHandler.post(() -> BluetoothCentralManager.this.bluetoothCentralManagerCallback.onConnectionFailed(peripheral, status));
            this.restartScannerIfNeeded();
        }

        @Override
        public void disconnected(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothCommandStatus status) {
            String peripheralAddress = peripheral.getAddress();
            BluetoothCentralManager.this.connectedPeripherals.remove(peripheralAddress);
            BluetoothCentralManager.this.unconnectedPeripherals.remove(peripheralAddress);
            BluetoothCentralManager.this.scannedPeripherals.remove(peripheralAddress);
            this.completeConnectOrDisconnectCommand(peripheralAddress);
            if (!peripheral.isPaired()) {
                BluetoothCentralManager.this.removeDevice(peripheral);
            }
            BluetoothCentralManager.this.callBackHandler.post(() -> BluetoothCentralManager.this.bluetoothCentralManagerCallback.onDisconnectedPeripheral(peripheral, status));
            this.restartScannerIfNeeded();
        }

        private void restartScannerIfNeeded() {
            if (BluetoothCentralManager.this.autoScanActive || BluetoothCentralManager.this.normalScanActive) {
                BluetoothCentralManager.this.startScanning();
            }
        }

        private void completeConnectOrDisconnectCommand(@NotNull String deviceAddress) {
            if (BluetoothCentralManager.this.currentCommand.equalsIgnoreCase("Connected") && deviceAddress.equalsIgnoreCase(BluetoothCentralManager.this.currentDeviceAddress)) {
                BluetoothCentralManager.this.completedCommand();
            }
        }
    };
    private final AbstractPropertiesChangedHandler propertiesChangedHandler = new AbstractPropertiesChangedHandler(){

        @Override
        public void handle(Properties.PropertiesChanged propertiesChanged) {
            switch (propertiesChanged.getInterfaceName()) {
                case "org.bluez.Device1": {
                    if (!BluetoothCentralManager.this.isScanning || BluetoothCentralManager.this.isStoppingScan) {
                        return;
                    }
                    BluezDevice bluezDevice = BluetoothCentralManager.this.getDeviceByPath(propertiesChanged.getPath());
                    if (bluezDevice == null) {
                        return;
                    }
                    BluetoothCentralManager.this.handlePropertiesChangedForDeviceWhenScanning(bluezDevice, propertiesChanged.getPropertiesChanged());
                    break;
                }
                case "org.bluez.Adapter1": {
                    propertiesChanged.getPropertiesChanged().forEach((propertyName, value) -> BluetoothCentralManager.this.handlePropertiesChangedForAdapter(propertyName, value));
                    break;
                }
            }
        }
    };

    public BluetoothCentralManager(@NotNull BluetoothCentralManagerCallback bluetoothCentralManagerCallback) {
        this(bluetoothCentralManagerCallback, Collections.emptySet());
    }

    public BluetoothCentralManager(@NotNull BluetoothCentralManagerCallback bluetoothCentralManagerCallback, @NotNull Set<String> scanOptions) {
        this(bluetoothCentralManagerCallback, scanOptions, new BluezAdapterProvider().adapter);
    }

    BluetoothCentralManager(@NotNull BluetoothCentralManagerCallback bluetoothCentralManagerCallback, @NotNull Set<String> scanOptions, @NotNull BluezAdapter bluezAdapter) {
        this.bluetoothCentralManagerCallback = Objects.requireNonNull(bluetoothCentralManagerCallback, "no valid bluetoothCallback provided");
        this.scanOptions = Objects.requireNonNull(scanOptions, "no scanOptions provided");
        this.adapter = Objects.requireNonNull(bluezAdapter, "no bluez adapter provided");
        this.logger.info(String.format("using adapter %s", this.adapter.getDeviceName()));
        this.isPowered = this.adapter.isPowered();
        if (!this.isPowered) {
            this.logger.info("adapter not on, so turning it on now");
            this.adapterOn();
        }
        try {
            this.setupPairingAgent();
            BluezSignalHandler.getInstance().addCentral(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupPairingAgent() throws BluezInvalidArgumentsException, BluezAlreadyExistsException, BluezDoesNotExistException {
        PairingAgent agent = new PairingAgent("/test/agent", this.adapter.getDBusConnection(), new PairingDelegate(){

            @Override
            public String requestPassCode(@NotNull String deviceAddress) {
                BluetoothCentralManager.this.logger.info(String.format("received passcode request for %s", deviceAddress));
                String passCode = BluetoothCentralManager.this.pinCodes.get(deviceAddress);
                if (passCode == null) {
                    passCode = BluetoothCentralManager.this.bluetoothCentralManagerCallback.onPinRequest(BluetoothCentralManager.this.getPeripheral(deviceAddress));
                }
                BluetoothCentralManager.this.logger.info(String.format("sending passcode %s", passCode));
                return passCode;
            }

            @Override
            public void onPairingStarted(@NotNull String deviceAddress) {
                BluetoothPeripheral peripheral = BluetoothCentralManager.this.getPeripheral(deviceAddress);
                peripheral.gattCallback.onPairingStarted();
            }
        });
        BluezAgentManager agentManager = DbusHelper.getBluezAgentManager(this.adapter.getDBusConnection());
        if (agentManager != null) {
            agentManager.registerAgent(agent, "KeyboardOnly");
            agentManager.requestDefaultAgent(agent);
        }
    }

    public void scanForPeripherals() {
        this.isScanning = this.adapter.isDiscovering();
        if (this.isScanning) {
            this.stopScan();
        }
        this.normalScanActive = true;
        this.resetScanFilters();
        this.startScanning();
    }

    public void scanForPeripheralsWithServices(@NotNull UUID[] serviceUUIDs) {
        Objects.requireNonNull(serviceUUIDs, "no service UUIDs supplied");
        if (serviceUUIDs.length == 0) {
            throw new IllegalArgumentException("at least one service UUID  must be supplied");
        }
        this.isScanning = this.adapter.isDiscovering();
        if (this.isScanning) {
            this.stopScan();
        }
        this.resetScanFilters();
        this.scanServiceUUIDs = new HashSet<UUID>(Arrays.asList(serviceUUIDs));
        this.normalScanActive = true;
        this.startScanning();
    }

    public void scanForPeripheralsWithNames(@NotNull String[] peripheralNames) {
        Objects.requireNonNull(peripheralNames, "no peripheral names supplied");
        if (peripheralNames.length == 0) {
            throw new IllegalArgumentException("at least one peripheral name must be supplied");
        }
        this.isScanning = this.adapter.isDiscovering();
        if (this.isScanning) {
            this.stopScan();
        }
        this.resetScanFilters();
        this.scanPeripheralNames = new HashSet<String>(Arrays.asList(peripheralNames));
        this.normalScanActive = true;
        this.startScanning();
    }

    public void scanForPeripheralsWithAddresses(@NotNull String[] peripheralAddresses) {
        Objects.requireNonNull(peripheralAddresses, "no peripheral addresses supplied");
        if (peripheralAddresses.length == 0) {
            throw new IllegalArgumentException("at least one peripheral address must be supplied");
        }
        this.isScanning = this.adapter.isDiscovering();
        if (this.isScanning) {
            this.stopScan();
        }
        this.resetScanFilters();
        this.scanPeripheralAddresses = new HashSet<String>(Arrays.asList(peripheralAddresses));
        this.normalScanActive = true;
        this.startScanning();
    }

    public void stopScan() {
        this.normalScanActive = false;
        this.stopScanning();
    }

    private void resetScanFilters() {
        this.scanPeripheralNames = new HashSet<String>();
        this.scanPeripheralAddresses = new HashSet<String>();
        this.scanServiceUUIDs = new HashSet<UUID>();
        this.scanFilters.clear();
        this.setBasicFilters();
    }

    private void setBasicFilters() {
        this.scanFilters.put(DiscoveryFilter.Transport, (Object)DiscoveryTransport.LE);
        this.scanFilters.put(DiscoveryFilter.RSSI, (short)-80);
        this.scanFilters.put(DiscoveryFilter.DuplicateData, true);
    }

    private boolean notAllowedByFilter(@NotNull ScanResult scanResult) {
        if (!this.scanPeripheralNames.isEmpty() && scanResult.getName() != null) {
            return !this.scanPeripheralNames.contains(scanResult.getName());
        }
        if (!this.scanPeripheralAddresses.isEmpty()) {
            return !this.scanPeripheralAddresses.contains(scanResult.getAddress());
        }
        if (!this.scanServiceUUIDs.isEmpty()) {
            List<UUID> scanResultUUIDs = scanResult.getUuids();
            for (UUID uuid : this.scanServiceUUIDs) {
                if (!scanResultUUIDs.contains(uuid)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void onFoundReconnectionPeripheral(@NotNull BluetoothPeripheral peripheral) {
        String peripheralAddress = peripheral.getAddress();
        BluetoothPeripheralCallback peripheralCallback = this.reconnectCallbacks.get(peripheralAddress);
        this.logger.info(String.format("found peripheral to autoconnect '%s'", peripheralAddress));
        this.autoScanActive = false;
        this.stopScanning();
        this.reconnectPeripheralAddresses.remove(peripheralAddress);
        this.reconnectCallbacks.remove(peripheralAddress);
        this.unconnectedPeripherals.remove(peripheralAddress);
        if (peripheral.getDevice() == null) {
            peripheral.setDevice(Objects.requireNonNull(this.getDeviceByAddress(peripheralAddress)));
            if (peripheral.getDevice() != null) {
                peripheral.setName(peripheral.getDevice().getName());
            }
        }
        this.connectPeripheral(peripheral, peripheralCallback);
        if (!this.reconnectPeripheralAddresses.isEmpty()) {
            this.autoScanActive = true;
            this.startScanning();
        } else if (this.normalScanActive) {
            this.startScanning();
        }
    }

    private void onScanResult(@NotNull BluetoothPeripheral peripheral, @NotNull ScanResult scanResult) {
        if (this.reconnectPeripheralAddresses.contains(scanResult.getAddress())) {
            this.onFoundReconnectionPeripheral(peripheral);
            return;
        }
        if (this.normalScanActive && this.isScanning && !this.isStoppingScan) {
            if (this.scanOptions.contains(SCANOPTION_NO_NULL_NAMES) && scanResult.getName() == null) {
                return;
            }
            if (this.notAllowedByFilter(scanResult)) {
                return;
            }
            this.callBackHandler.post(() -> {
                scanResult.stamp();
                this.bluetoothCentralManagerCallback.onDiscoveredPeripheral(peripheral, scanResult);
            });
        }
    }

    void handleInterfaceAddedForDevice(@NotNull String path, @NotNull Map<String, Variant<?>> value) {
        ArrayList serviceUUIDs = null;
        if (value.get("Address") == null || !(value.get("Address").getValue() instanceof String)) {
            return;
        }
        String deviceAddress = (String)value.get("Address").getValue();
        BluezDevice device = this.getDeviceByAddress(deviceAddress);
        if (device == null) {
            return;
        }
        String deviceName = value.get("Name") != null && value.get("Name").getValue() instanceof String ? (String)value.get("Name").getValue() : null;
        if (value.get("UUIDs") != null && value.get("UUIDs").getValue() instanceof ArrayList) {
            serviceUUIDs = (ArrayList)value.get("UUIDs").getValue();
        }
        int rssi = value.get("RSSI") != null && value.get("RSSI").getValue() instanceof Short ? (int)((Short)value.get("RSSI").getValue()).shortValue() : -80;
        ArrayList<@NotNull UUID> finalServiceUUIDs = new ArrayList<UUID>();
        if (serviceUUIDs != null) {
            serviceUUIDs.stream().map(UUID::fromString).forEach(finalServiceUUIDs::add);
        }
        HashMap<Integer, byte[]> manufacturerData = new HashMap<Integer, byte[]>();
        if (value.get("ManufacturerData") != null && value.get("ManufacturerData").getValue() instanceof Map) {
            DBusMap mdata = (DBusMap)value.get("ManufacturerData").getValue();
            mdata.forEach((k, v) -> {
                byte[] cfr_ignored_0 = (byte[])manufacturerData.put(k.intValue(), (byte[])v.getValue());
            });
        }
        HashMap<String, byte[]> serviceData = new HashMap<String, byte[]>();
        if (value.get("ServiceData") != null && value.get("ServiceData").getValue() instanceof Map) {
            DBusMap sdata = (DBusMap)value.get("ServiceData").getValue();
            sdata.forEach((k, v) -> {
                byte[] cfr_ignored_0 = (byte[])serviceData.put((String)k, (byte[])v.getValue());
            });
        }
        ScanResult scanResult = new ScanResult(deviceName, deviceAddress, finalServiceUUIDs, rssi, manufacturerData, serviceData);
        BluetoothPeripheral peripheral = this.getPeripheral(deviceAddress);
        this.scanResultCache.put(deviceAddress, scanResult);
        this.onScanResult(peripheral, scanResult);
    }

    void handleSignal(@NotNull Properties.PropertiesChanged propertiesChanged) {
        this.signalHandler.post(() -> this.propertiesChangedHandler.handle(propertiesChanged));
    }

    private void handlePropertiesChangedForDeviceWhenScanning(@NotNull BluezDevice bluezDevice, @NotNull Map<String, Variant<?>> propertiesChanged) {
        Objects.requireNonNull(bluezDevice, "no valid bluezDevice supplied");
        Objects.requireNonNull(propertiesChanged, "no valid propertieschanged supplied");
        String deviceAddress = bluezDevice.getAddress();
        if (deviceAddress == null) {
            return;
        }
        Set<String> keys = propertiesChanged.keySet();
        if (!(keys.contains("RSSI") || keys.contains("ManufacturerData") || keys.contains("ServiceData"))) {
            return;
        }
        ScanResult scanResult = this.getScanResult(deviceAddress);
        if (scanResult == null) {
            scanResult = this.getScanResultFromDevice(bluezDevice);
            this.scanResultCache.put(deviceAddress, scanResult);
        }
        this.updateScanResult(propertiesChanged, scanResult);
        BluetoothPeripheral peripheral = this.getPeripheral(deviceAddress);
        this.onScanResult(peripheral, scanResult);
    }

    private void updateScanResult(@NotNull Map<String, Variant<?>> propertiesChanged, @NotNull ScanResult scanResult) {
        Set<String> keys = propertiesChanged.keySet();
        if (keys.contains("RSSI")) {
            scanResult.setRssi(((Short)propertiesChanged.get("RSSI").getValue()).shortValue());
        }
        if (keys.contains("ManufacturerData")) {
            HashMap<Integer, byte[]> manufacturerData = new HashMap<Integer, byte[]>();
            DBusMap mdata = (DBusMap)propertiesChanged.get("ManufacturerData").getValue();
            mdata.forEach((k, v) -> {
                byte[] cfr_ignored_0 = (byte[])manufacturerData.put(k.intValue(), (byte[])v.getValue());
            });
            scanResult.setManufacturerData(manufacturerData);
        }
        if (keys.contains("ServiceData")) {
            HashMap<String, byte[]> serviceData = new HashMap<String, byte[]>();
            DBusMap sdata = (DBusMap)propertiesChanged.get("ServiceData").getValue();
            sdata.forEach((k, v) -> {
                byte[] cfr_ignored_0 = (byte[])serviceData.put((String)k, (byte[])v.getValue());
            });
            scanResult.setServiceData(serviceData);
        }
    }

    @NotNull
    private ScanResult getScanResultFromDevice(@NotNull BluezDevice bluezDevice) {
        Objects.requireNonNull(bluezDevice, "no valid bluezDevice supplied");
        String deviceName = bluezDevice.getName();
        String deviceAddress = bluezDevice.getAddress();
        List<@NotNull UUID> uuids = bluezDevice.getUuids();
        Short rssi = bluezDevice.getRssi();
        int rssiInt = rssi == null ? -80 : (int)rssi.shortValue();
        Map<@NotNull Integer, byte[]> manufacturerData = bluezDevice.getManufacturerData();
        Map<@NotNull String, byte[]> serviceData = bluezDevice.getServiceData();
        return new ScanResult(deviceName, deviceAddress, uuids, rssiInt, manufacturerData, serviceData);
    }

    private void handlePropertiesChangedForAdapter(@NotNull String propertyName, @NotNull Variant<?> value) {
        switch (propertyName) {
            case "Discovering": {
                this.isScanning = (Boolean)value.getValue();
                this.logger.info(String.format("scan %s", this.isScanning ? "started" : "stopped"));
                if (this.isScanning) {
                    this.isStoppingScan = false;
                    this.callBackHandler.post(this.bluetoothCentralManagerCallback::onScanStarted);
                } else {
                    this.scannedPeripherals.clear();
                    this.scannedBluezDevices.clear();
                    this.scanResultCache.clear();
                    this.callBackHandler.post(this.bluetoothCentralManagerCallback::onScanStopped);
                }
                if (!this.currentCommand.equalsIgnoreCase(PROPERTY_DISCOVERING)) break;
                this.callBackHandler.postDelayed(this::completedCommand, 100L);
                break;
            }
            case "Powered": {
                this.isPowered = (Boolean)value.getValue();
                this.logger.info(String.format("powered %s", this.isPowered ? "on" : "off"));
                if (!this.currentCommand.equalsIgnoreCase(PROPERTY_POWERED)) break;
                this.callBackHandler.postDelayed(this::completedCommand, 100L);
                break;
            }
        }
    }

    private void setScanFilter(@NotNull Map<DiscoveryFilter, Object> filter) throws BluezInvalidArgumentsException, BluezNotReadyException, BluezNotSupportedException, BluezFailedException {
        LinkedHashMap filters = new LinkedHashMap();
        for (Map.Entry<DiscoveryFilter, Object> entry : filter.entrySet()) {
            if (!entry.getKey().getValueClass().isInstance(entry.getValue())) {
                throw new BluezInvalidArgumentsException("Filter value not of required type " + entry.getKey().getValueClass());
            }
            if (entry.getValue() instanceof Enum) {
                filters.put(entry.getKey().name(), new Variant<String>(entry.getValue().toString()));
                continue;
            }
            filters.put(entry.getKey().name(), new Variant<Object>(entry.getValue()));
        }
        this.adapter.setDiscoveryFilter(filters);
    }

    private void startScanning() {
        if (!this.isPowered) {
            return;
        }
        boolean result = this.commandQueue.add(() -> {
            this.isStoppingScan = false;
            this.isScanning = this.adapter.isDiscovering();
            if (this.isScanning) {
                this.completedCommand();
                return;
            }
            try {
                this.setScanFilter(this.scanFilters);
            }
            catch (BluezFailedException | BluezInvalidArgumentsException | BluezNotReadyException | BluezNotSupportedException e) {
                this.logger.error("Error setting scan filer");
                this.logger.error(e.toString());
            }
            try {
                this.currentCommand = PROPERTY_DISCOVERING;
                this.adapter.startDiscovery();
                this.startScanTimer();
            }
            catch (BluezFailedException e) {
                this.logger.error("Could not start discovery (failed)");
                this.completedCommand();
            }
            catch (BluezNotReadyException e) {
                this.logger.error("Could not start discovery (not ready)");
                this.completedCommand();
            }
            catch (DBusExecutionException e) {
                this.logger.error("Error starting scanner");
                this.logger.error(e.getMessage());
                this.completedCommand();
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            this.logger.error(ENQUEUE_ERROR);
        }
    }

    private void stopScanning() {
        if (!this.isPowered) {
            return;
        }
        this.isStoppingScan = true;
        boolean result = this.commandQueue.add(() -> {
            this.isScanning = this.adapter.isDiscovering();
            if (!this.isScanning) {
                this.isStoppingScan = false;
                this.completedCommand();
                return;
            }
            try {
                this.currentCommand = PROPERTY_DISCOVERING;
                this.cancelTimeoutTimer();
                this.adapter.stopDiscovery();
            }
            catch (BluezNotReadyException e) {
                this.logger.error("Could not stop discovery (not ready)");
                this.completedCommand();
            }
            catch (BluezFailedException e) {
                this.logger.error("Could not stop discovery (failed)");
                this.completedCommand();
            }
            catch (BluezNotAuthorizedException e) {
                this.logger.error("Could not stop discovery (not authorized)");
                this.completedCommand();
            }
            catch (DBusExecutionException e) {
                this.logger.error(e.getMessage());
                if (e.getMessage().equalsIgnoreCase("No discovery started")) {
                    this.logger.error("Could not stop scan, because we are not scanning!");
                    this.isStoppingScan = false;
                    this.isScanning = false;
                } else if (e.getMessage().equalsIgnoreCase("Operation already in progress")) {
                    this.logger.error("a stopDiscovery is in progress");
                }
                this.completedCommand();
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            this.logger.error(ENQUEUE_ERROR);
        }
    }

    private void startScanTimer() {
        this.cancelTimeoutTimer();
        Runnable timeoutRunnable = () -> {
            this.stopScanning();
            this.queueHandler.postDelayed(this::startScanning, SCAN_INTERVAL - SCAN_WINDOW);
        };
        this.timeoutFuture = this.queueHandler.postDelayed(timeoutRunnable, SCAN_WINDOW);
    }

    private void cancelTimeoutTimer() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
    }

    public void adapterOn() {
        boolean result = this.commandQueue.add(() -> {
            if (!this.adapter.isPowered()) {
                this.logger.info("Turning on adapter");
                this.currentCommand = PROPERTY_POWERED;
                this.adapter.setPowered(true);
            } else {
                this.logger.info("Adapter already on");
                this.completedCommand();
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            this.logger.error(ENQUEUE_ERROR);
        }
    }

    public void adapterOff() {
        boolean result = this.commandQueue.add(() -> {
            if (this.adapter.isPowered()) {
                this.logger.info("Turning off adapter");
                this.currentCommand = PROPERTY_POWERED;
                this.adapter.setPowered(false);
            } else {
                this.logger.info("Adapter already off");
                this.completedCommand();
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            this.logger.error(ENQUEUE_ERROR);
        }
    }

    public void connectPeripheral(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothPeripheralCallback peripheralCallback) {
        Objects.requireNonNull(peripheral, NULL_PERIPHERAL_ERROR);
        Objects.requireNonNull(peripheralCallback, "no valid peripheral callback specified");
        peripheral.setPeripheralCallback(peripheralCallback);
        if (this.connectedPeripherals.containsKey(peripheral.getAddress())) {
            this.logger.warn(String.format("WARNING: Already connected to %s'", peripheral.getAddress()));
            return;
        }
        if (this.unconnectedPeripherals.containsKey(peripheral.getAddress())) {
            this.logger.warn(String.format("WARNING: Already connecting to %s'", peripheral.getAddress()));
            return;
        }
        if (peripheral.getDevice() == null) {
            this.logger.warn(String.format("WARNING: Peripheral '%s' doesn't have Bluez device", peripheral.getAddress()));
            return;
        }
        this.stopScanning();
        this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
        boolean result = this.commandQueue.add(() -> {
            try {
                Thread.sleep(CONNECT_DELAY);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.scannedBluezDevices.remove(this.adapter.getPath(peripheral.getAddress()));
            BluezDevice bluezDevice = this.getDeviceByAddress(peripheral.getAddress());
            if (bluezDevice != null) {
                peripheral.setDevice(bluezDevice);
            }
            this.currentDeviceAddress = peripheral.getAddress();
            this.currentCommand = "Connected";
            try {
                peripheral.connect();
            }
            catch (NullPointerException ignored) {
                this.completedCommand();
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            this.logger.error(ENQUEUE_ERROR);
        }
    }

    public boolean autoConnectPeripheral(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothPeripheralCallback peripheralCallback) {
        Objects.requireNonNull(peripheral, NULL_PERIPHERAL_ERROR);
        Objects.requireNonNull(peripheralCallback, "no valid peripheral callback specified");
        String peripheralAddress = peripheral.getAddress();
        if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
            return false;
        }
        this.reconnectPeripheralAddresses.add(peripheralAddress);
        this.reconnectCallbacks.put(peripheralAddress, peripheralCallback);
        this.unconnectedPeripherals.put(peripheralAddress, peripheral);
        this.logger.info(String.format("autoconnect to %s", peripheralAddress));
        this.startAutoConnectScan();
        return true;
    }

    public void autoConnectPeripheralsBatch(@NotNull Map<BluetoothPeripheral, BluetoothPeripheralCallback> batch) {
        Objects.requireNonNull(batch, "no valid batch provided");
        for (Map.Entry<BluetoothPeripheral, BluetoothPeripheralCallback> entry : batch.entrySet()) {
            String peripheralAddress = entry.getKey().getAddress();
            this.reconnectPeripheralAddresses.add(peripheralAddress);
            this.reconnectCallbacks.put(peripheralAddress, entry.getValue());
            this.unconnectedPeripherals.put(peripheralAddress, entry.getKey());
        }
        if (!this.reconnectPeripheralAddresses.isEmpty()) {
            this.startAutoConnectScan();
        }
    }

    private void startAutoConnectScan() {
        this.autoScanActive = true;
        if (!this.isScanning) {
            this.setBasicFilters();
            this.startScanning();
        }
    }

    public void cancelConnection(@NotNull BluetoothPeripheral peripheral) {
        Objects.requireNonNull(peripheral, NULL_PERIPHERAL_ERROR);
        if (peripheral.getState() == ConnectionState.CONNECTED) {
            this.stopScanning();
            boolean result = this.commandQueue.add(() -> {
                this.currentDeviceAddress = peripheral.getAddress();
                this.currentCommand = "Connected";
                peripheral.disconnectBluezDevice();
            });
            if (result) {
                this.nextCommand();
            } else {
                this.logger.error(ENQUEUE_ERROR);
            }
            return;
        }
        String peripheralAddress = peripheral.getAddress();
        if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
            this.reconnectPeripheralAddresses.remove(peripheralAddress);
            this.reconnectCallbacks.remove(peripheralAddress);
            this.callBackHandler.post(() -> this.bluetoothCentralManagerCallback.onDisconnectedPeripheral(peripheral, BluetoothCommandStatus.COMMAND_SUCCESS));
        }
    }

    public boolean removeBond(@NotNull String peripheralAddress) {
        Objects.requireNonNull(peripheralAddress, "no peripheral address provided");
        BluezDevice bluezDevice = this.getDeviceByAddress(peripheralAddress);
        if (bluezDevice == null) {
            return false;
        }
        return this.removeDevice(bluezDevice);
    }

    @NotNull
    public List<BluetoothPeripheral> getConnectedPeripherals() {
        return new ArrayList<BluetoothPeripheral>(this.connectedPeripherals.values());
    }

    @NotNull
    public BluetoothPeripheral getPeripheral(@NotNull String peripheralAddress) {
        BluezDevice bluezDevice;
        Objects.requireNonNull(peripheralAddress, "no valid peripheral address provided");
        if (!this.isValidBluetoothAddress(peripheralAddress)) {
            String message = String.format("%s is not a valid address. Make sure all alphabetic characters are uppercase.", peripheralAddress);
            throw new IllegalArgumentException(message);
        }
        if (this.scannedPeripherals.containsKey(peripheralAddress)) {
            return this.scannedPeripherals.get(peripheralAddress);
        }
        if (this.connectedPeripherals.containsKey(peripheralAddress)) {
            return this.connectedPeripherals.get(peripheralAddress);
        }
        if (this.unconnectedPeripherals.containsKey(peripheralAddress)) {
            return this.unconnectedPeripherals.get(peripheralAddress);
        }
        BluetoothPeripheral bluetoothPeripheral = new BluetoothPeripheral(this, bluezDevice, (bluezDevice = this.getDeviceByAddress(peripheralAddress)) != null ? bluezDevice.getName() : null, peripheralAddress, this.internalCallback, null, this.callBackHandler);
        this.scannedPeripherals.put(peripheralAddress, bluetoothPeripheral);
        return bluetoothPeripheral;
    }

    @Nullable
    private ScanResult getScanResult(@NotNull String peripheralAddress) {
        return this.scanResultCache.get(peripheralAddress);
    }

    public boolean setPinCodeForPeripheral(@NotNull String peripheralAddress, @NotNull String pin) {
        Objects.requireNonNull(peripheralAddress, "no peripheral address provided");
        Objects.requireNonNull(pin, "no pin provided");
        if (!this.isValidBluetoothAddress(peripheralAddress)) {
            this.logger.error(String.format("%s is not a valid address. Make sure all alphabetic characters are uppercase.", peripheralAddress));
            return false;
        }
        if (pin.length() != 6) {
            this.logger.error(String.format("%s is not 6 digits long", pin));
            return false;
        }
        this.pinCodes.put(peripheralAddress, pin);
        return true;
    }

    private boolean isValidBluetoothAddress(@NotNull String address) {
        Objects.requireNonNull(address, "address is null");
        if (address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void completedCommand() {
        this.commandQueue.poll();
        this.commandQueueBusy = false;
        this.currentCommand = "";
        this.nextCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextCommand() {
        BluetoothCentralManager bluetoothCentralManager = this;
        synchronized (bluetoothCentralManager) {
            if (this.commandQueueBusy) {
                return;
            }
            Runnable bluetoothCommand = this.commandQueue.peek();
            if (bluetoothCommand != null) {
                this.commandQueueBusy = true;
                this.queueHandler.post(() -> {
                    try {
                        bluetoothCommand.run();
                    }
                    catch (Exception ex) {
                        this.logger.warn("ERROR: Command exception for central");
                        this.logger.warn(ex.getMessage());
                        this.completedCommand();
                    }
                });
            }
        }
    }

    @Nullable
    private BluezDevice getDeviceByPath(@NotNull String devicePath) {
        Objects.requireNonNull(devicePath, "device path is null");
        BluezDevice bluezDevice = this.scannedBluezDevices.get(devicePath);
        if (bluezDevice == null && (bluezDevice = this.adapter.getBluezDeviceByPath(devicePath)) != null) {
            this.scannedBluezDevices.put(devicePath, bluezDevice);
        }
        return bluezDevice;
    }

    @Nullable
    private BluezDevice getDeviceByAddress(@NotNull String deviceAddress) {
        Objects.requireNonNull(deviceAddress, "device address is null");
        return this.getDeviceByPath(this.adapter.getPath(deviceAddress));
    }

    protected void removeDevice(@NotNull BluetoothPeripheral peripheral) {
        BluezDevice bluetoothDevice = this.getDeviceByAddress(peripheral.getAddress());
        if (bluetoothDevice == null) {
            return;
        }
        boolean isBonded = peripheral.isPaired();
        this.logger.info(String.format("removing peripheral '%s' %s (%s)", peripheral.getName(), peripheral.getAddress(), isBonded ? "BONDED" : "BOND_NONE"));
        this.removeDevice(bluetoothDevice);
    }

    private boolean removeDevice(@NotNull BluezDevice bluetoothDevice) {
        try {
            Device1 rawDevice = bluetoothDevice.getRawDevice();
            if (rawDevice != null) {
                this.adapter.removeDevice(rawDevice);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.logger.error("Error removing device");
            return false;
        }
    }
}

