/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.LoggerFactory;

public enum SearchOrder {
    CUSTOM_PATH,
    CLASS_PATH,
    SYSTEM_PATH;


    public static InputStream findFile(String _fileName, SearchOrder ... _order) {
        if (_fileName == null || _fileName.isEmpty() || _order == null) {
            return null;
        }
        InputStream result = null;
        block5: for (SearchOrder so : _order) {
            switch (so) {
                case CLASS_PATH: {
                    result = SearchOrder.class.getClassLoader().getResourceAsStream(_fileName);
                    if (result == null) continue block5;
                    return result;
                }
                case CUSTOM_PATH: {
                    File file = new File(_fileName);
                    if (!file.exists() || (result = SearchOrder.toStream(file)) == null) continue block5;
                    return result;
                }
                case SYSTEM_PATH: {
                    String getenv = System.getenv("PATH");
                    getenv = getenv.replace(";", ":");
                    for (String p : getenv.split(":")) {
                        File curFile = new File(p, _fileName);
                        if (!curFile.exists() || (result = SearchOrder.toStream(curFile)) == null) continue;
                        return result;
                    }
                    continue block5;
                }
            }
        }
        return result;
    }

    private static InputStream toStream(File _file) {
        try {
            return new FileInputStream(_file);
        }
        catch (FileNotFoundException _ex) {
            LoggerFactory.getLogger(SearchOrder.class).debug("File {} not found", (Object)_file);
            return null;
        }
    }
}

